/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.mapstruct.ap.internal.model.MappingMethod;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.model.source.SourceReference;
import org.mapstruct.ap.internal.util.Strings;

public class NestedPropertyMappingMethod
extends MappingMethod {
    private final List<SafePropertyEntry> safePropertyEntries;

    private NestedPropertyMappingMethod(Method method, List<SafePropertyEntry> sourcePropertyEntries) {
        super(method);
        this.safePropertyEntries = sourcePropertyEntries;
    }

    public Parameter getSourceParameter() {
        for (Parameter parameter : this.getParameters()) {
            if (parameter.isMappingTarget()) continue;
            return parameter;
        }
        throw new IllegalStateException("Method " + this + " has no source parameter.");
    }

    public List<SafePropertyEntry> getPropertyEntries() {
        return this.safePropertyEntries;
    }

    @Override
    public Set<Type> getImportTypes() {
        Set<Type> types = super.getImportTypes();
        for (SafePropertyEntry propertyEntry : this.safePropertyEntries) {
            types.add(propertyEntry.getType());
        }
        return types;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getReturnType() == null ? 0 : this.getReturnType().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NestedPropertyMappingMethod other = (NestedPropertyMappingMethod)obj;
        if (!this.getReturnType().equals(other.getReturnType())) {
            return false;
        }
        if (this.getSourceParameters().size() != other.getSourceParameters().size()) {
            return false;
        }
        for (int i = 0; i < this.getSourceParameters().size(); ++i) {
            if (this.getSourceParameters().get(i).getType().equals(other.getSourceParameters().get(i).getType())) continue;
            return false;
        }
        return this.getName().equals(other.getName());
    }

    public static class SafePropertyEntry
    extends SourceReference.PropertyEntry {
        private final String safeName;

        public SafePropertyEntry(SourceReference.PropertyEntry entry, String safeName) {
            super(entry.getName(), entry.getAccessor(), entry.getType());
            this.safeName = safeName;
        }

        @Override
        public String getName() {
            return this.safeName;
        }

        public String getAccessorName() {
            return this.getAccessor().getSimpleName().toString();
        }
    }

    public static class Builder {
        private Method method;
        private List<SourceReference.PropertyEntry> propertyEntries;

        public Builder method(Method sourceMethod) {
            this.method = sourceMethod;
            return this;
        }

        public Builder propertyEntries(List<SourceReference.PropertyEntry> propertyEntries) {
            this.propertyEntries = propertyEntries;
            return this;
        }

        public NestedPropertyMappingMethod build() {
            ArrayList<String> existingVariableNames = new ArrayList<String>();
            for (Parameter parameter : this.method.getSourceParameters()) {
                existingVariableNames.add(parameter.getName());
            }
            ArrayList<SafePropertyEntry> safePropertyEntries = new ArrayList<SafePropertyEntry>();
            for (SourceReference.PropertyEntry propertyEntry : this.propertyEntries) {
                String safeName = Strings.getSaveVariableName(propertyEntry.getName(), existingVariableNames);
                safePropertyEntries.add(new SafePropertyEntry(propertyEntry, safeName));
                existingVariableNames.add(safeName);
            }
            return new NestedPropertyMappingMethod(this.method, safePropertyEntries);
        }
    }
}

