/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.services;

import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class Services {
    private static final ConcurrentMap<Class<?>, Object> SERVICES = new ConcurrentHashMap();

    private Services() {
    }

    public static <T> T get(Class<T> serviceType, T defaultValue) {
        Object service = SERVICES.get(serviceType);
        if (service == null) {
            service = Services.loadAndCache(serviceType, defaultValue);
        }
        return (T)service;
    }

    private static <T> T loadAndCache(Class<T> serviceType, T defaultValue) {
        Object cached;
        Object service = Services.find(serviceType);
        if (service == null) {
            service = defaultValue;
        }
        if ((cached = SERVICES.putIfAbsent(serviceType, service)) != null) {
            service = cached;
        }
        return service;
    }

    private static <T> T find(Class<T> spi) {
        Object matchingImplementation = null;
        for (T implementation : ServiceLoader.load(spi, spi.getClassLoader())) {
            if (matchingImplementation == null) {
                matchingImplementation = implementation;
                continue;
            }
            throw new IllegalStateException("Multiple implementations have been found for the service provider interface " + spi.getCanonicalName() + ": " + matchingImplementation.getClass().getCanonicalName() + ", " + implementation.getClass().getCanonicalName() + ".");
        }
        return (T)matchingImplementation;
    }
}

