/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.mapstruct.ap.internal.model.DefaultMappingExclusionProvider;
import org.mapstruct.ap.internal.model.ForgedMethod;
import org.mapstruct.ap.internal.model.MapperReference;
import org.mapstruct.ap.internal.model.MappingMethod;
import org.mapstruct.ap.internal.model.SupportingMappingMethod;
import org.mapstruct.ap.internal.model.common.Assignment;
import org.mapstruct.ap.internal.model.common.FormattingParameters;
import org.mapstruct.ap.internal.model.common.SourceRHS;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.common.TypeFactory;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.model.source.SourceMethod;
import org.mapstruct.ap.internal.model.source.selector.SelectionCriteria;
import org.mapstruct.ap.internal.option.Options;
import org.mapstruct.ap.internal.util.AccessorNamingUtils;
import org.mapstruct.ap.internal.util.FormattingMessager;
import org.mapstruct.ap.internal.util.Services;
import org.mapstruct.ap.spi.EnumNamingStrategy;
import org.mapstruct.ap.spi.EnumTransformationStrategy;
import org.mapstruct.ap.spi.MappingExclusionProvider;

public class MappingBuilderContext {
    private static final MappingExclusionProvider SUB_MAPPING_EXCLUSION_PROVIDER = Services.get(MappingExclusionProvider.class, new DefaultMappingExclusionProvider());
    private final TypeFactory typeFactory;
    private final Elements elementUtils;
    private final Types typeUtils;
    private final FormattingMessager messager;
    private final AccessorNamingUtils accessorNaming;
    private final EnumNamingStrategy enumNamingStrategy;
    private final Map<String, EnumTransformationStrategy> enumTransformationStrategies;
    private final Options options;
    private final TypeElement mapperTypeElement;
    private final List<SourceMethod> sourceModel;
    private final List<MapperReference> mapperReferences;
    private final MappingResolver mappingResolver;
    private final List<MappingMethod> mappingsToGenerate = new ArrayList<MappingMethod>();
    private final Map<ForgedMethod, ForgedMethod> forgedMethodsUnderCreation = new HashMap<ForgedMethod, ForgedMethod>();

    public MappingBuilderContext(TypeFactory typeFactory, Elements elementUtils, Types typeUtils, FormattingMessager messager, AccessorNamingUtils accessorNaming, EnumNamingStrategy enumNamingStrategy, Map<String, EnumTransformationStrategy> enumTransformationStrategies, Options options, MappingResolver mappingResolver, TypeElement mapper, List<SourceMethod> sourceModel, List<MapperReference> mapperReferences) {
        this.typeFactory = typeFactory;
        this.elementUtils = elementUtils;
        this.typeUtils = typeUtils;
        this.messager = messager;
        this.accessorNaming = accessorNaming;
        this.enumNamingStrategy = enumNamingStrategy;
        this.enumTransformationStrategies = enumTransformationStrategies;
        this.options = options;
        this.mappingResolver = mappingResolver;
        this.mapperTypeElement = mapper;
        this.sourceModel = sourceModel;
        this.mapperReferences = mapperReferences;
    }

    public Map<ForgedMethod, ForgedMethod> getForgedMethodsUnderCreation() {
        return this.forgedMethodsUnderCreation;
    }

    public TypeElement getMapperTypeElement() {
        return this.mapperTypeElement;
    }

    public List<SourceMethod> getSourceModel() {
        return this.sourceModel;
    }

    public List<MapperReference> getMapperReferences() {
        return this.mapperReferences;
    }

    public TypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    public Elements getElementUtils() {
        return this.elementUtils;
    }

    public Types getTypeUtils() {
        return this.typeUtils;
    }

    public FormattingMessager getMessager() {
        return this.messager;
    }

    public AccessorNamingUtils getAccessorNaming() {
        return this.accessorNaming;
    }

    public EnumNamingStrategy getEnumNamingStrategy() {
        return this.enumNamingStrategy;
    }

    public Map<String, EnumTransformationStrategy> getEnumTransformationStrategies() {
        return this.enumTransformationStrategies;
    }

    public Options getOptions() {
        return this.options;
    }

    public MappingResolver getMappingResolver() {
        return this.mappingResolver;
    }

    public List<MappingMethod> getMappingsToGenerate() {
        return this.mappingsToGenerate;
    }

    public List<String> getReservedNames() {
        HashSet<String> nameSet = new HashSet<String>();
        for (MappingMethod mappingMethod : this.mappingsToGenerate) {
            nameSet.add(mappingMethod.getName());
        }
        for (SourceMethod sourceMethod : this.sourceModel) {
            if (!sourceMethod.isAbstract()) continue;
            nameSet.add(sourceMethod.getName());
        }
        return new ArrayList<String>(nameSet);
    }

    public MappingMethod getExistingMappingMethod(MappingMethod newMappingMethod) {
        MappingMethod existingMappingMethod = null;
        for (MappingMethod mappingMethod : this.mappingsToGenerate) {
            if (!newMappingMethod.equals(mappingMethod)) continue;
            existingMappingMethod = mappingMethod;
            break;
        }
        return existingMappingMethod;
    }

    public Set<SupportingMappingMethod> getUsedSupportedMappings() {
        return this.mappingResolver.getUsedSupportedMappings();
    }

    public boolean canGenerateAutoSubMappingBetween(Type sourceType, Type targetType) {
        return this.canGenerateAutoSubMappingFor(sourceType) && this.canGenerateAutoSubMappingFor(targetType);
    }

    private boolean canGenerateAutoSubMappingFor(Type type) {
        return type.getTypeElement() != null && !SUB_MAPPING_EXCLUSION_PROVIDER.isExcluded(type.getTypeElement());
    }

    public boolean isErroneous() {
        return this.messager.isErroneous();
    }

    public static interface MappingResolver {
        public Assignment getTargetAssignment(Method var1, Type var2, FormattingParameters var3, SelectionCriteria var4, SourceRHS var5, AnnotationMirror var6, Supplier<Assignment> var7);

        public Set<SupportingMappingMethod> getUsedSupportedMappings();
    }
}

