/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.source;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.mapstruct.ap.internal.gem.CollectionMappingStrategyGem;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.common.TypeFactory;
import org.mapstruct.ap.internal.model.source.BeanMappingOptions;
import org.mapstruct.ap.internal.model.source.EnumMappingOptions;
import org.mapstruct.ap.internal.model.source.IterableMappingOptions;
import org.mapstruct.ap.internal.model.source.MapMappingOptions;
import org.mapstruct.ap.internal.model.source.MapperOptions;
import org.mapstruct.ap.internal.model.source.MappingOptions;
import org.mapstruct.ap.internal.model.source.SourceMethod;
import org.mapstruct.ap.internal.model.source.ValueMappingOptions;
import org.mapstruct.ap.internal.util.accessor.Accessor;

public class MappingMethodOptions {
    private static final MappingMethodOptions EMPTY = new MappingMethodOptions(null, Collections.emptySet(), null, null, null, null, Collections.emptyList());
    private MapperOptions mapper;
    private Set<MappingOptions> mappings;
    private IterableMappingOptions iterableMapping;
    private MapMappingOptions mapMapping;
    private BeanMappingOptions beanMapping;
    private EnumMappingOptions enumMappingOptions;
    private List<ValueMappingOptions> valueMappings;
    private boolean fullyInitialized;

    public MappingMethodOptions(MapperOptions mapper, Set<MappingOptions> mappings, IterableMappingOptions iterableMapping, MapMappingOptions mapMapping, BeanMappingOptions beanMapping, EnumMappingOptions enumMappingOptions, List<ValueMappingOptions> valueMappings) {
        this.mapper = mapper;
        this.mappings = mappings;
        this.iterableMapping = iterableMapping;
        this.mapMapping = mapMapping;
        this.beanMapping = beanMapping;
        this.enumMappingOptions = enumMappingOptions;
        this.valueMappings = valueMappings;
    }

    public static MappingMethodOptions empty() {
        return EMPTY;
    }

    public Set<MappingOptions> getMappings() {
        return this.mappings;
    }

    public IterableMappingOptions getIterableMapping() {
        return this.iterableMapping;
    }

    public MapMappingOptions getMapMapping() {
        return this.mapMapping;
    }

    public BeanMappingOptions getBeanMapping() {
        return this.beanMapping;
    }

    public EnumMappingOptions getEnumMappingOptions() {
        return this.enumMappingOptions;
    }

    public List<ValueMappingOptions> getValueMappings() {
        return this.valueMappings;
    }

    public void setIterableMapping(IterableMappingOptions iterableMapping) {
        this.iterableMapping = iterableMapping;
    }

    public void setMapMapping(MapMappingOptions mapMapping) {
        this.mapMapping = mapMapping;
    }

    public void setBeanMapping(BeanMappingOptions beanMapping) {
        this.beanMapping = beanMapping;
    }

    public void setEnumMappingOptions(EnumMappingOptions enumMappingOptions) {
        this.enumMappingOptions = enumMappingOptions;
    }

    public void setValueMappings(List<ValueMappingOptions> valueMappings) {
        this.valueMappings = valueMappings;
    }

    public MapperOptions getMapper() {
        return this.mapper;
    }

    public boolean isFullyInitialized() {
        return this.fullyInitialized;
    }

    public void markAsFullyInitialized() {
        this.fullyInitialized = true;
    }

    public void applyInheritedOptions(SourceMethod templateMethod, boolean isInverse, SourceMethod method) {
        MappingMethodOptions templateOptions = templateMethod.getOptions();
        if (null != templateOptions) {
            if (!this.getIterableMapping().hasAnnotation() && templateOptions.getIterableMapping().hasAnnotation()) {
                this.setIterableMapping(templateOptions.getIterableMapping());
            }
            if (!this.getMapMapping().hasAnnotation() && templateOptions.getMapMapping().hasAnnotation()) {
                this.setMapMapping(templateOptions.getMapMapping());
            }
            if (!this.getBeanMapping().hasAnnotation() && templateOptions.getBeanMapping().hasAnnotation()) {
                this.setBeanMapping(BeanMappingOptions.forInheritance(templateOptions.getBeanMapping()));
            }
            if (!this.getEnumMappingOptions().hasAnnotation() && templateOptions.getEnumMappingOptions().hasAnnotation()) {
                EnumMappingOptions newEnumMappingOptions = isInverse ? templateOptions.getEnumMappingOptions().inverse() : templateOptions.getEnumMappingOptions();
                this.setEnumMappingOptions(newEnumMappingOptions);
            }
            if (this.getValueMappings() == null) {
                if (templateOptions.getValueMappings() != null) {
                    this.setValueMappings(templateOptions.getValueMappings());
                } else {
                    this.setValueMappings(Collections.emptyList());
                }
            } else if (templateOptions.getValueMappings() != null) {
                for (ValueMappingOptions inheritedValueMapping : templateOptions.getValueMappings()) {
                    ValueMappingOptions valueMapping = isInverse ? inheritedValueMapping.inverse() : inheritedValueMapping;
                    if (valueMapping == null || this.getValueMappings().contains(valueMapping)) continue;
                    this.getValueMappings().add(valueMapping);
                }
            }
            LinkedHashSet<MappingOptions> newMappings = new LinkedHashSet<MappingOptions>();
            for (MappingOptions mapping : templateOptions.getMappings()) {
                if (isInverse) {
                    if (!mapping.canInverse()) continue;
                    newMappings.add(mapping.copyForInverseInheritance(templateMethod, this.getBeanMapping()));
                    continue;
                }
                newMappings.add(mapping.copyForForwardInheritance(templateMethod, this.getBeanMapping()));
            }
            this.mappings.addAll(newMappings);
            this.filterNestedTargetIgnores(this.mappings);
        }
    }

    public void applyIgnoreAll(SourceMethod method, TypeFactory typeFactory) {
        CollectionMappingStrategyGem cms = method.getOptions().getMapper().getCollectionMappingStrategy();
        Type writeType = method.getResultType();
        if (!method.isUpdateMethod()) {
            writeType = typeFactory.effectiveResultTypeFor(writeType, method.getOptions().getBeanMapping().getBuilder());
        }
        Map<String, Accessor> writeAccessors = writeType.getPropertyWriteAccessors(cms);
        Set mappedPropertyNames = this.mappings.stream().map(m -> this.getPropertyEntries((MappingOptions)m)[0]).collect(Collectors.toSet());
        for (String targetPropertyName : writeAccessors.keySet()) {
            if (mappedPropertyNames.contains(targetPropertyName)) continue;
            MappingOptions mapping = MappingOptions.forIgnore(targetPropertyName);
            this.mappings.add(mapping);
        }
    }

    private void filterNestedTargetIgnores(Set<MappingOptions> mappings) {
        Set<String> ignored = MappingOptions.getMappingTargetNamesBy(MappingOptions::isIgnored, mappings);
        mappings.removeIf(m -> this.isToBeIgnored(ignored, (MappingOptions)m));
    }

    private boolean isToBeIgnored(Set<String> ignored, MappingOptions mapping) {
        String[] propertyEntries = this.getPropertyEntries(mapping);
        return propertyEntries.length > 1 && ignored.contains(propertyEntries[0]);
    }

    private String[] getPropertyEntries(MappingOptions mapping) {
        return mapping.getTargetName().split("\\.");
    }
}

