/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Collections {
    private Collections() {
    }

    @SafeVarargs
    public static <T> Set<T> asSet(T ... elements) {
        HashSet set = new HashSet(elements.length);
        java.util.Collections.addAll(set, elements);
        return set;
    }

    @SafeVarargs
    public static <T> Set<T> asSet(Collection<T> collection, T ... elements) {
        HashSet set = new HashSet(collection.size() + elements.length);
        java.util.Collections.addAll(set, elements);
        return set;
    }

    @SafeVarargs
    public static <T> Set<T> asSet(Collection<T> collection, Collection<T> ... elements) {
        HashSet<T> set = new HashSet<T>(collection);
        for (Collection<T> element : elements) {
            set.addAll(element);
        }
        return set;
    }

    public static <T> T first(Collection<T> collection) {
        return collection.iterator().next();
    }

    public static <T> T last(List<T> list) {
        return list.get(list.size() - 1);
    }

    public static <T> List<T> join(List<T> a, List<T> b) {
        ArrayList<T> result = new ArrayList<T>(a.size() + b.size());
        result.addAll(a);
        result.addAll(b);
        return result;
    }
}

