/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.mapstruct.ap.internal.model.MappingBuilderContext;
import org.mapstruct.ap.internal.model.PropertyMapping;
import org.mapstruct.ap.internal.model.beanmapping.AbstractReference;
import org.mapstruct.ap.internal.model.beanmapping.MappingReference;
import org.mapstruct.ap.internal.model.beanmapping.MappingReferences;
import org.mapstruct.ap.internal.model.beanmapping.PropertyEntry;
import org.mapstruct.ap.internal.model.beanmapping.SourceReference;
import org.mapstruct.ap.internal.model.beanmapping.TargetReference;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.source.MappingOptions;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.util.Collections;
import org.mapstruct.ap.internal.util.Message;
import org.mapstruct.ap.internal.util.Strings;
import org.mapstruct.ap.internal.util.accessor.Accessor;

public class NestedTargetPropertyMappingHolder {
    private final List<Parameter> processedSourceParameters;
    private final Set<String> handledTargets;
    private final List<PropertyMapping> propertyMappings;
    private final Map<String, Set<MappingReference>> unprocessedDefinedTarget;
    private final boolean errorOccurred;

    public NestedTargetPropertyMappingHolder(List<Parameter> processedSourceParameters, Set<String> handledTargets, List<PropertyMapping> propertyMappings, Map<String, Set<MappingReference>> unprocessedDefinedTarget, boolean errorOccurred) {
        this.processedSourceParameters = processedSourceParameters;
        this.handledTargets = handledTargets;
        this.propertyMappings = propertyMappings;
        this.unprocessedDefinedTarget = unprocessedDefinedTarget;
        this.errorOccurred = errorOccurred;
    }

    public List<Parameter> getProcessedSourceParameters() {
        return this.processedSourceParameters;
    }

    public Set<String> getHandledTargets() {
        return this.handledTargets;
    }

    public List<PropertyMapping> getPropertyMappings() {
        return this.propertyMappings;
    }

    public Map<String, Set<MappingReference>> getUnprocessedDefinedTarget() {
        return this.unprocessedDefinedTarget;
    }

    public boolean hasErrorOccurred() {
        return this.errorOccurred;
    }

    private static class GroupedSourceReferences {
        private final Map<PropertyEntry, Set<MappingReference>> groupedBySourceReferences;
        private final Set<MappingReference> nonNested;
        private final Set<MappingReference> notProcessedAppliesToAll;
        private final Set<MappingReference> sourceParameterMappings;

        private GroupedSourceReferences(Map<PropertyEntry, Set<MappingReference>> groupedBySourceReferences, Set<MappingReference> nonNested, Set<MappingReference> notProcessedAppliesToAll, Set<MappingReference> sourceParameterMappings) {
            this.groupedBySourceReferences = groupedBySourceReferences;
            this.nonNested = nonNested;
            this.notProcessedAppliesToAll = notProcessedAppliesToAll;
            this.sourceParameterMappings = sourceParameterMappings;
        }

        public String toString() {
            return "GroupedSourceReferences{groupedBySourceReferences=" + this.groupedBySourceReferences + ", nonNested=" + this.nonNested + ", notProcessedAppliesToAll=" + this.notProcessedAppliesToAll + ", sourceParameterMappings=" + this.sourceParameterMappings + '}';
        }
    }

    private static class GroupedTargetReferences {
        private final Map<String, Set<MappingReference>> poppedTargetReferences;
        private final Map<String, Set<MappingReference>> singleTargetReferences;

        private GroupedTargetReferences(Map<String, Set<MappingReference>> poppedTargetReferences, Map<String, Set<MappingReference>> singleTargetReferences) {
            this.poppedTargetReferences = poppedTargetReferences;
            this.singleTargetReferences = singleTargetReferences;
        }

        public String toString() {
            return "GroupedTargetReferences{poppedTargetReferences=" + this.poppedTargetReferences + ", singleTargetReferences=" + this.singleTargetReferences + "}";
        }
    }

    private static class GroupedBySourceParameters {
        private final Map<Parameter, Set<MappingReference>> groupedBySourceParameter;
        private final Set<MappingReference> notProcessedAppliesToAll;

        private GroupedBySourceParameters(Map<Parameter, Set<MappingReference>> groupedBySourceParameter, Set<MappingReference> notProcessedAppliesToAll) {
            this.groupedBySourceParameter = groupedBySourceParameter;
            this.notProcessedAppliesToAll = notProcessedAppliesToAll;
        }
    }

    public static class Builder {
        private Method method;
        private MappingReferences mappingReferences;
        private MappingBuilderContext mappingContext;
        private Set<String> existingVariableNames;
        private List<PropertyMapping> propertyMappings;
        private Set<String> handledTargets;
        private Map<String, Accessor> targetPropertiesWriteAccessors;
        private Type targetType;
        private boolean errorOccurred;

        public Builder mappingReferences(MappingReferences mappingReferences) {
            this.mappingReferences = mappingReferences;
            return this;
        }

        public Builder method(Method method) {
            this.method = method;
            return this;
        }

        public Builder mappingContext(MappingBuilderContext mappingContext) {
            this.mappingContext = mappingContext;
            return this;
        }

        public Builder existingVariableNames(Set<String> existingVariableNames) {
            this.existingVariableNames = existingVariableNames;
            return this;
        }

        public Builder targetPropertiesWriteAccessors(Map<String, Accessor> targetPropertiesWriteAccessors) {
            this.targetPropertiesWriteAccessors = targetPropertiesWriteAccessors;
            return this;
        }

        public Builder targetPropertyType(Type targetType) {
            this.targetType = targetType;
            return this;
        }

        public NestedTargetPropertyMappingHolder build() {
            ArrayList<Parameter> processedSourceParameters = new ArrayList<Parameter>();
            this.handledTargets = new HashSet<String>();
            this.propertyMappings = new ArrayList<PropertyMapping>();
            GroupedTargetReferences groupedByTP = this.groupByTargetReferences();
            LinkedHashMap<String, Set<MappingReference>> unprocessedDefinedTarget = new LinkedHashMap<String, Set<MappingReference>>();
            for (Map.Entry entryByTP : groupedByTP.poppedTargetReferences.entrySet()) {
                String targetProperty = (String)entryByTP.getKey();
                GroupedBySourceParameters groupedBySourceParam = this.groupBySourceParameter((Set)entryByTP.getValue(), (Set)groupedByTP.singleTargetReferences.get(targetProperty));
                boolean multipleSourceParametersForTP = groupedBySourceParam.groupedBySourceParameter.keySet().size() > 1;
                unprocessedDefinedTarget.put(targetProperty, groupedBySourceParam.notProcessedAppliesToAll);
                for (Map.Entry<Parameter, Set<MappingReference>> entry : groupedBySourceParam.groupedBySourceParameter.entrySet()) {
                    Parameter sourceParameter = (Parameter)entry.getKey();
                    GroupedSourceReferences groupedSourceReferences = this.groupByPoppedSourceReferences(entry, (Set)groupedByTP.singleTargetReferences.get(targetProperty));
                    boolean forceUpdateMethod = multipleSourceParametersForTP || groupedSourceReferences.groupedBySourceReferences.size() > 1;
                    boolean forceUpdateMethodOrNonNestedReferencesPresent = forceUpdateMethod || !groupedSourceReferences.nonNested.isEmpty();
                    for (Map.Entry entryBySP : groupedSourceReferences.groupedBySourceReferences.entrySet()) {
                        SourceReference sourceRef;
                        PropertyEntry sourceEntry = (PropertyEntry)entryBySP.getKey();
                        MappingReferences sourceMappingRefs = new MappingReferences((Set<MappingReference>)((Set)entryBySP.getValue()), multipleSourceParametersForTP, forceUpdateMethodOrNonNestedReferencesPresent);
                        PropertyMapping propertyMapping = this.createPropertyMappingForNestedTarget(sourceMappingRefs, targetProperty, sourceRef = new SourceReference.BuilderFromProperty().sourceParameter(sourceParameter).type(sourceEntry.getType()).readAccessor(sourceEntry.getReadAccessor()).presenceChecker(sourceEntry.getPresenceChecker()).name(targetProperty).build(), forceUpdateMethodOrNonNestedReferencesPresent);
                        if (propertyMapping != null) {
                            this.propertyMappings.add(propertyMapping);
                        }
                        this.handledTargets.add((String)entryByTP.getKey());
                    }
                    if (!groupedSourceReferences.nonNested.isEmpty()) {
                        boolean forceUpdateMethodForNonNested;
                        SourceReference reference;
                        MappingReferences mappingReferences = new MappingReferences(groupedSourceReferences.nonNested, true);
                        PropertyMapping propertyMapping = this.createPropertyMappingForNestedTarget(mappingReferences, targetProperty, reference = new SourceReference.BuilderFromProperty().sourceParameter(sourceParameter).name(targetProperty).build(), forceUpdateMethodForNonNested = multipleSourceParametersForTP || !groupedSourceReferences.groupedBySourceReferences.isEmpty());
                        if (propertyMapping != null) {
                            this.propertyMappings.add(propertyMapping);
                        }
                        this.handledTargets.add((String)entryByTP.getKey());
                    }
                    this.handleSourceParameterMappings(groupedSourceReferences.sourceParameterMappings, targetProperty, sourceParameter, multipleSourceParametersForTP);
                    unprocessedDefinedTarget.put(targetProperty, groupedSourceReferences.notProcessedAppliesToAll);
                }
            }
            return new NestedTargetPropertyMappingHolder(processedSourceParameters, this.handledTargets, this.propertyMappings, unprocessedDefinedTarget, this.errorOccurred);
        }

        private void handleSourceParameterMappings(Set<MappingReference> sourceParameterMappings, String targetProperty, Parameter sourceParameter, boolean forceUpdateMethod) {
            if (!sourceParameterMappings.isEmpty()) {
                SourceReference reference;
                MappingReferences nonNestedRefs = new MappingReferences(java.util.Collections.emptySet(), false, true);
                PropertyMapping propertyMapping = this.createPropertyMappingForNestedTarget(nonNestedRefs, targetProperty, reference = new SourceReference.BuilderFromProperty().sourceParameter(sourceParameter).name(targetProperty).build(), forceUpdateMethod);
                if (propertyMapping != null) {
                    this.propertyMappings.add(propertyMapping);
                }
                this.handledTargets.add(targetProperty);
            }
        }

        private GroupedTargetReferences groupByTargetReferences() {
            LinkedHashMap<String, Set> mappingsKeyedByProperty = new LinkedHashMap<String, Set>();
            LinkedHashMap<String, Set> singleTargetReferences = new LinkedHashMap<String, Set>();
            for (MappingReference mapping : this.mappingReferences.getMappingReferences()) {
                TargetReference targetReference = mapping.getTargetReference();
                String property = Collections.first(targetReference.getPropertyEntries());
                MappingReference newMapping = mapping.popTargetReference();
                if (newMapping != null) {
                    mappingsKeyedByProperty.computeIfAbsent(property, propertyEntry -> new LinkedHashSet()).add(newMapping);
                    continue;
                }
                singleTargetReferences.computeIfAbsent(property, propertyEntry -> new LinkedHashSet()).add(mapping);
            }
            return new GroupedTargetReferences(mappingsKeyedByProperty, singleTargetReferences);
        }

        private GroupedBySourceParameters groupBySourceParameter(Set<MappingReference> mappings, Set<MappingReference> singleTargetReferences) {
            LinkedHashMap<Parameter, Set> mappingsKeyedByParameter = new LinkedHashMap<Parameter, Set>();
            LinkedHashSet<MappingReference> appliesToAll = new LinkedHashSet<MappingReference>();
            for (MappingReference mappingReference : mappings) {
                if (mappingReference.getSourceReference() != null && mappingReference.getSourceReference().isValid()) {
                    Parameter parameter = mappingReference.getSourceReference().getParameter();
                    mappingsKeyedByParameter.computeIfAbsent(parameter, key -> new LinkedHashSet()).add(mappingReference);
                    continue;
                }
                appliesToAll.add(mappingReference);
            }
            this.populateWithSingleTargetReferences(mappingsKeyedByParameter, singleTargetReferences, AbstractReference::getParameter);
            for (Map.Entry entry : mappingsKeyedByParameter.entrySet()) {
                ((Set)entry.getValue()).addAll(appliesToAll);
            }
            LinkedHashSet<MappingReference> notProcessAppliesToAll = mappingsKeyedByParameter.isEmpty() ? appliesToAll : new LinkedHashSet<MappingReference>();
            return new GroupedBySourceParameters(mappingsKeyedByParameter, notProcessAppliesToAll);
        }

        private GroupedSourceReferences groupByPoppedSourceReferences(Map.Entry<Parameter, Set<MappingReference>> entryByParam, Set<MappingReference> singleTargetReferences) {
            Set<MappingReference> mappings = entryByParam.getValue();
            LinkedHashSet<MappingReference> nonNested = new LinkedHashSet<MappingReference>();
            LinkedHashSet<MappingReference> appliesToAll = new LinkedHashSet<MappingReference>();
            LinkedHashSet<MappingReference> sourceParameterMappings = new LinkedHashSet<MappingReference>();
            LinkedHashMap<PropertyEntry, Set> mappingsKeyedByProperty = new LinkedHashMap<PropertyEntry, Set>();
            for (MappingReference mapping : mappings) {
                MappingReference newMapping = mapping.popSourceReference();
                if (newMapping != null) {
                    PropertyEntry property = Collections.first(mapping.getSourceReference().getPropertyEntries());
                    mappingsKeyedByProperty.computeIfAbsent(property, propertyEntry -> new LinkedHashSet()).add(newMapping);
                    continue;
                }
                if (mapping.getSourceReference() == null) {
                    appliesToAll.add(mapping);
                    continue;
                }
                nonNested.add(mapping);
            }
            boolean hasNoMappings = mappingsKeyedByProperty.isEmpty() && nonNested.isEmpty();
            Parameter sourceParameter = entryByParam.getKey();
            Set<MappingReference> singleTargetReferencesToUse = this.extractSingleTargetReferencesToUseAndPopulateSourceParameterMappings(singleTargetReferences, sourceParameterMappings, hasNoMappings, sourceParameter);
            this.populateWithSingleTargetReferences(mappingsKeyedByProperty, singleTargetReferencesToUse, sourceReference -> sourceReference.getPropertyEntries().isEmpty() ? null : Collections.first(sourceReference.getPropertyEntries()));
            for (Map.Entry entry : mappingsKeyedByProperty.entrySet()) {
                ((Set)entry.getValue()).addAll(appliesToAll);
            }
            LinkedHashSet<MappingReference> notProcessedAppliesToAll = new LinkedHashSet<MappingReference>();
            if (mappingsKeyedByProperty.isEmpty() && !nonNested.isEmpty()) {
                nonNested.addAll(appliesToAll);
            } else if (mappingsKeyedByProperty.isEmpty() && nonNested.isEmpty()) {
                notProcessedAppliesToAll.addAll(appliesToAll);
            }
            return new GroupedSourceReferences(mappingsKeyedByProperty, nonNested, notProcessedAppliesToAll, sourceParameterMappings);
        }

        private Set<MappingReference> extractSingleTargetReferencesToUseAndPopulateSourceParameterMappings(Set<MappingReference> singleTargetReferences, Set<MappingReference> sourceParameterMappings, boolean hasNoMappings, Parameter sourceParameter) {
            LinkedHashSet<MappingReference> singleTargetReferencesToUse = null;
            if (singleTargetReferences != null) {
                singleTargetReferencesToUse = new LinkedHashSet<MappingReference>(singleTargetReferences.size());
                for (MappingReference mapping : singleTargetReferences) {
                    if (mapping.getSourceReference() == null || !mapping.getSourceReference().isValid() || !sourceParameter.equals(mapping.getSourceReference().getParameter())) continue;
                    if (hasNoMappings && mapping.getSourceReference().getPropertyEntries().isEmpty()) {
                        sourceParameterMappings.add(mapping);
                        continue;
                    }
                    singleTargetReferencesToUse.add(mapping);
                }
            }
            return singleTargetReferencesToUse;
        }

        private PropertyMapping createPropertyMappingForNestedTarget(MappingReferences mappingReferences, String targetPropertyName, SourceReference sourceReference, boolean forceUpdateMethod) {
            Accessor targetWriteAccessor = this.targetPropertiesWriteAccessors.get(targetPropertyName);
            Accessor targetReadAccessor = this.targetType.getPropertyReadAccessors().get(targetPropertyName);
            if (targetWriteAccessor == null) {
                Set<String> readAccessors = this.targetType.getPropertyReadAccessors().keySet();
                String mostSimilarProperty = Strings.getMostSimilarWord(targetPropertyName, readAccessors);
                for (MappingReference mappingReference : mappingReferences.getMappingReferences()) {
                    MappingOptions mapping = mappingReference.getMapping();
                    ArrayList<String> pathProperties = new ArrayList<String>(mappingReference.getTargetReference().getPathProperties());
                    if (!pathProperties.isEmpty()) {
                        pathProperties.set(pathProperties.size() - 1, mostSimilarProperty);
                    }
                    this.mappingContext.getMessager().printMessage(mapping.getElement(), mapping.getMirror(), mapping.getTargetAnnotationValue(), Message.BEANMAPPING_UNKNOWN_PROPERTY_IN_TYPE, targetPropertyName, this.targetType.describe(), mapping.getTargetName(), Strings.join(pathProperties, "."));
                }
                this.errorOccurred = true;
                return null;
            }
            return ((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)new PropertyMapping.PropertyMappingBuilder().mappingContext(this.mappingContext)).sourceMethod(this.method)).target(targetPropertyName, targetReadAccessor, targetWriteAccessor)).sourceReference(sourceReference).existingVariableNames((Set)this.existingVariableNames)).dependsOn((Set)mappingReferences.collectNestedDependsOn())).forgeMethodWithMappingReferences(mappingReferences).forceUpdateMethod(forceUpdateMethod).forgedNamedBased(false).options(this.method.getOptions().getBeanMapping()).build();
        }

        private <K> void populateWithSingleTargetReferences(Map<K, Set<MappingReference>> map, Set<MappingReference> singleTargetReferences, Function<SourceReference, K> keyExtractor) {
            if (singleTargetReferences != null) {
                for (MappingReference mapping : singleTargetReferences) {
                    K key;
                    if (mapping.getSourceReference() == null || !mapping.getSourceReference().isValid() || (key = keyExtractor.apply(mapping.getSourceReference())) == null) continue;
                    map.computeIfAbsent(key, keyValue -> new LinkedHashSet());
                }
            }
        }
    }
}

