/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.processor;

import java.util.Map;
import java.util.stream.IntStream;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import org.mapstruct.ap.internal.model.common.TypeFactory;
import org.mapstruct.ap.internal.option.Options;
import org.mapstruct.ap.internal.processor.DefaultVersionInformation;
import org.mapstruct.ap.internal.processor.ModelElementProcessor;
import org.mapstruct.ap.internal.util.AccessorNamingUtils;
import org.mapstruct.ap.internal.util.ElementUtils;
import org.mapstruct.ap.internal.util.FormattingMessager;
import org.mapstruct.ap.internal.util.Message;
import org.mapstruct.ap.internal.util.RoundContext;
import org.mapstruct.ap.internal.util.TypeUtils;
import org.mapstruct.ap.internal.version.VersionInformation;
import org.mapstruct.ap.spi.EnumMappingStrategy;
import org.mapstruct.ap.spi.EnumTransformationStrategy;

public class DefaultModelElementProcessorContext
implements ModelElementProcessor.ProcessorContext {
    private final ProcessingEnvironment processingEnvironment;
    private final DelegatingMessager messager;
    private final Options options;
    private final TypeFactory typeFactory;
    private final VersionInformation versionInformation;
    private final TypeUtils delegatingTypes;
    private final ElementUtils delegatingElements;
    private final AccessorNamingUtils accessorNaming;
    private final RoundContext roundContext;

    public DefaultModelElementProcessorContext(ProcessingEnvironment processingEnvironment, Options options, RoundContext roundContext, Map<String, String> notToBeImported) {
        this.processingEnvironment = processingEnvironment;
        this.messager = new DelegatingMessager(processingEnvironment.getMessager(), options.isVerbose());
        this.accessorNaming = roundContext.getAnnotationProcessorContext().getAccessorNaming();
        this.versionInformation = DefaultVersionInformation.fromProcessingEnvironment(processingEnvironment);
        this.delegatingTypes = TypeUtils.create(processingEnvironment, this.versionInformation);
        this.delegatingElements = ElementUtils.create(processingEnvironment, this.versionInformation);
        this.roundContext = roundContext;
        this.typeFactory = new TypeFactory(this.delegatingElements, this.delegatingTypes, this.messager, roundContext, notToBeImported, options.isVerbose());
        this.options = options;
    }

    @Override
    public Filer getFiler() {
        return this.processingEnvironment.getFiler();
    }

    @Override
    public TypeUtils getTypeUtils() {
        return this.delegatingTypes;
    }

    @Override
    public ElementUtils getElementUtils() {
        return this.delegatingElements;
    }

    @Override
    public TypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    @Override
    public FormattingMessager getMessager() {
        return this.messager;
    }

    @Override
    public AccessorNamingUtils getAccessorNaming() {
        return this.accessorNaming;
    }

    @Override
    public Map<String, EnumTransformationStrategy> getEnumTransformationStrategies() {
        return this.roundContext.getAnnotationProcessorContext().getEnumTransformationStrategies();
    }

    @Override
    public EnumMappingStrategy getEnumMappingStrategy() {
        return this.roundContext.getAnnotationProcessorContext().getEnumMappingStrategy();
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    @Override
    public VersionInformation getVersionInformation() {
        return this.versionInformation;
    }

    @Override
    public boolean isErroneous() {
        return this.messager.isErroneous();
    }

    private static final class DelegatingMessager
    implements FormattingMessager {
        private final Messager delegate;
        private boolean isErroneous = false;
        private final boolean verbose;

        DelegatingMessager(Messager delegate, boolean verbose) {
            this.delegate = delegate;
            this.verbose = verbose;
        }

        @Override
        public void printMessage(Message msg, Object ... args) {
            String message = String.format(msg.getDescription(), args);
            this.delegate.printMessage(msg.getDiagnosticKind(), message);
            if (msg.getDiagnosticKind() == Diagnostic.Kind.ERROR) {
                this.isErroneous = true;
            }
        }

        @Override
        public void printMessage(Element e, Message msg, Object ... args) {
            String message = String.format(msg.getDescription(), args);
            this.delegate.printMessage(msg.getDiagnosticKind(), message, e);
            if (msg.getDiagnosticKind() == Diagnostic.Kind.ERROR) {
                this.isErroneous = true;
            }
        }

        @Override
        public void printMessage(Element e, AnnotationMirror a, Message msg, Object ... args) {
            if (a == null) {
                this.printMessage(e, msg, args);
            } else {
                String message = String.format(msg.getDescription(), args);
                this.delegate.printMessage(msg.getDiagnosticKind(), message, e, a);
                if (msg.getDiagnosticKind() == Diagnostic.Kind.ERROR) {
                    this.isErroneous = true;
                }
            }
        }

        @Override
        public void printMessage(Element e, AnnotationMirror a, AnnotationValue v, Message msg, Object ... args) {
            String message = String.format(msg.getDescription(), args);
            this.delegate.printMessage(msg.getDiagnosticKind(), message, e, a, v);
            if (msg.getDiagnosticKind() == Diagnostic.Kind.ERROR) {
                this.isErroneous = true;
            }
        }

        @Override
        public void note(int level, Message msg, Object ... args) {
            if (this.verbose) {
                StringBuilder builder = new StringBuilder();
                IntStream.range(0, level).mapToObj(i -> "-").forEach(builder::append);
                builder.append(" MapStruct: ").append(String.format(msg.getDescription(), args));
                this.delegate.printMessage(Diagnostic.Kind.NOTE, builder.toString());
            }
        }

        @Override
        public boolean isErroneous() {
            return this.isErroneous;
        }
    }
}

