/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.mapstruct.ap.internal.model.ForgedMethod;
import org.mapstruct.ap.internal.model.MappingBuilderContext;
import org.mapstruct.ap.internal.model.MappingMethod;
import org.mapstruct.ap.internal.model.beanmapping.PropertyEntry;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.common.PresenceCheck;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.presence.SuffixPresenceCheck;
import org.mapstruct.ap.internal.util.Strings;
import org.mapstruct.ap.internal.util.accessor.PresenceCheckAccessor;

public class NestedPropertyMappingMethod
extends MappingMethod {
    private final List<SafePropertyEntry> safePropertyEntries;

    private NestedPropertyMappingMethod(ForgedMethod method, List<SafePropertyEntry> sourcePropertyEntries) {
        super(method);
        this.safePropertyEntries = sourcePropertyEntries;
    }

    public Parameter getSourceParameter() {
        for (Parameter parameter : this.getParameters()) {
            if (parameter.isMappingTarget() || parameter.isMappingContext()) continue;
            return parameter;
        }
        throw new IllegalStateException("Method " + this + " has no source parameter.");
    }

    public List<SafePropertyEntry> getPropertyEntries() {
        return this.safePropertyEntries;
    }

    @Override
    public Set<Type> getImportTypes() {
        Set<Type> types = super.getImportTypes();
        for (SafePropertyEntry propertyEntry : this.safePropertyEntries) {
            types.addAll(propertyEntry.getType().getImportTypes());
            if (propertyEntry.getPresenceChecker() == null) continue;
            types.addAll(propertyEntry.getPresenceChecker().getImportTypes());
        }
        return types;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getReturnType() == null ? 0 : this.getReturnType().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NestedPropertyMappingMethod other = (NestedPropertyMappingMethod)obj;
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getSourceParameters().size() != other.getSourceParameters().size()) {
            return false;
        }
        for (int i = 0; i < this.getSourceParameters().size(); ++i) {
            if (this.getSourceParameters().get(i).getType().equals(other.getSourceParameters().get(i).getType())) continue;
            return false;
        }
        return this.safePropertyEntries.equals(other.safePropertyEntries);
    }

    public static class SafePropertyEntry {
        private final String safeName;
        private final String readAccessorName;
        private final PresenceCheck presenceChecker;
        private final String previousPropertyName;
        private final Type type;

        public SafePropertyEntry(PropertyEntry entry, String safeName, String previousPropertyName) {
            this.safeName = safeName;
            this.readAccessorName = entry.getReadAccessor().getReadValueSource();
            PresenceCheckAccessor presenceChecker = entry.getPresenceChecker();
            this.presenceChecker = presenceChecker != null ? new SuffixPresenceCheck(previousPropertyName, presenceChecker.getPresenceCheckSuffix()) : null;
            this.previousPropertyName = previousPropertyName;
            this.type = entry.getType();
        }

        public String getName() {
            return this.safeName;
        }

        public String getAccessorName() {
            return this.readAccessorName;
        }

        public PresenceCheck getPresenceChecker() {
            return this.presenceChecker;
        }

        public String getPreviousPropertyName() {
            return this.previousPropertyName;
        }

        public Type getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SafePropertyEntry)) {
                return false;
            }
            SafePropertyEntry that = (SafePropertyEntry)o;
            if (!Objects.equals(this.readAccessorName, that.readAccessorName)) {
                return false;
            }
            if (!Objects.equals(this.presenceChecker, that.presenceChecker)) {
                return false;
            }
            if (!Objects.equals(this.previousPropertyName, that.previousPropertyName)) {
                return false;
            }
            return Objects.equals(this.type, that.type);
        }

        public int hashCode() {
            int result = this.readAccessorName != null ? this.readAccessorName.hashCode() : 0;
            result = 31 * result + (this.presenceChecker != null ? this.presenceChecker.hashCode() : 0);
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            return result;
        }
    }

    public static class Builder {
        private MappingBuilderContext ctx;
        private ForgedMethod method;
        private List<PropertyEntry> propertyEntries;

        public Builder method(ForgedMethod sourceMethod) {
            this.method = sourceMethod;
            return this;
        }

        public Builder propertyEntries(List<PropertyEntry> propertyEntries) {
            this.propertyEntries = propertyEntries;
            return this;
        }

        public Builder mappingContext(MappingBuilderContext mappingContext) {
            this.ctx = mappingContext;
            return this;
        }

        public NestedPropertyMappingMethod build() {
            ArrayList<String> existingVariableNames = new ArrayList<String>();
            Parameter sourceParameter = null;
            for (Parameter parameter : this.method.getSourceParameters()) {
                existingVariableNames.add(parameter.getName());
                if (sourceParameter != null || parameter.isMappingTarget() || parameter.isMappingContext()) continue;
                sourceParameter = parameter;
            }
            ArrayList<Type> thrownTypes = new ArrayList<Type>();
            ArrayList<SafePropertyEntry> safePropertyEntries = new ArrayList<SafePropertyEntry>();
            if (sourceParameter == null) {
                throw new IllegalStateException("Method " + this.method + " has no source parameter.");
            }
            String previousPropertyName = sourceParameter.getName();
            for (PropertyEntry propertyEntry : this.propertyEntries) {
                String safeName = Strings.getSafeVariableName(propertyEntry.getName(), existingVariableNames);
                safePropertyEntries.add(new SafePropertyEntry(propertyEntry, safeName, previousPropertyName));
                existingVariableNames.add(safeName);
                thrownTypes.addAll(this.ctx.getTypeFactory().getThrownTypes(propertyEntry.getReadAccessor()));
                previousPropertyName = safeName;
            }
            this.method.addThrownTypes(thrownTypes);
            return new NestedPropertyMappingMethod(this.method, safePropertyEntries);
        }
    }
}

