/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.tools.gem.processor;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import org.mapstruct.tools.gem.processor.GemValueInfo;
import org.mapstruct.tools.gem.processor.GemValueType;

public class GemInfo {
    private static final String BUILDER_NAME = "Builder";
    private static final String BUILDER_IMPL_NAME = "BuilderImpl";
    private final String gemPackageName;
    private final String annotationName;
    private final String annotationFqn;
    private final String gemName;
    private final String builderName;
    private final String builderImplName;
    private final List<GemValueInfo> gemValueInfos;
    private final Element[] originatingElements;

    public GemInfo(String gemPackageName, String annotationName, String annotationFqn, List<GemValueInfo> gemValueInfos, Element ... originatingElements) {
        this.gemPackageName = gemPackageName;
        this.gemName = annotationName + "Gem";
        this.annotationName = annotationName;
        this.annotationFqn = annotationFqn;
        this.gemValueInfos = gemValueInfos;
        this.builderName = BUILDER_NAME + (BUILDER_NAME.equals(annotationName) ? "_" : "");
        this.builderImplName = BUILDER_IMPL_NAME + (BUILDER_IMPL_NAME.equals(annotationName) ? "_" : "");
        this.originatingElements = Arrays.copyOf(originatingElements, originatingElements.length);
    }

    public String getGemName() {
        return this.gemName;
    }

    public String getAnnotationName() {
        return this.annotationName;
    }

    public String getAnnotationFqn() {
        return this.annotationFqn;
    }

    public String getGemPackageName() {
        return this.gemPackageName;
    }

    public List<GemValueInfo> getGemValueInfos() {
        return this.gemValueInfos;
    }

    public Set<String> getImports() {
        return this.gemValueInfos.stream().map(GemValueInfo::getValueType).filter(this::isNotJavaLang).filter(this::isNotSamePackage).map(GemValueType::getFqn).collect(Collectors.toSet());
    }

    public String getBuilderName() {
        return this.builderName;
    }

    public String getBuilderImplName() {
        return this.builderImplName;
    }

    public Element[] getOriginatingElements() {
        return this.originatingElements;
    }

    private boolean isNotSamePackage(GemValueType valueType) {
        return !valueType.getPacakage().equals(this.gemPackageName);
    }

    private boolean isNotJavaLang(GemValueType valueType) {
        return !"java.lang".equals(valueType.getPacakage());
    }
}

