/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.tools.gem.processor;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import org.mapstruct.tools.gem.processor.GemInfo;
import org.mapstruct.tools.gem.processor.GemValueInfo;
import org.mapstruct.tools.gem.processor.GemValueType;
import org.mapstruct.tools.gem.processor.Util;
import org.mapstruct.tools.gem.processor.shaded.freemarker.template.Configuration;
import org.mapstruct.tools.gem.processor.shaded.freemarker.template.Template;
import org.mapstruct.tools.gem.processor.shaded.freemarker.template.TemplateException;
import org.mapstruct.tools.gem.processor.shaded.freemarker.template.Version;

@SupportedAnnotationTypes(value={"org.mapstruct.tools.gem.GemDefinitions"})
public class GemProcessor
extends AbstractProcessor {
    private Util util;
    private List<GemInfo> gemInfos = new ArrayList<GemInfo>(10);

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotationTypes, RoundEnvironment roundEnv) {
        try {
            this.util = new Util(this.processingEnv.getTypeUtils(), this.processingEnv.getElementUtils());
            for (TypeElement typeElement : annotationTypes) {
                for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                    AnnotationMirror gemDefinitionsMirror = element.getAnnotationMirrors().stream().filter(t -> this.util.isSame(t.getAnnotationType(), "org.mapstruct.tools.gem.GemDefinitions")).findFirst().orElseThrow(IllegalStateException::new);
                    List gemDefinitionMirrors = this.util.getAnnotationValue(gemDefinitionsMirror, "value", List.class);
                    gemDefinitionMirrors.stream().forEach(m -> this.addGemInfo((AnnotationMirror)m, definingElement));
                }
            }
            this.postProcessGemInfo();
            this.write();
        }
        catch (RuntimeException ex) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter pw = new PrintWriter(stringWriter);
            ex.printStackTrace(pw);
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, stringWriter.toString());
        }
        return true;
    }

    private void addGemInfo(AnnotationMirror gemDefinitionMirror, Element definingElement) {
        DeclaredType gemDeclaredType = this.util.getAnnotationValue(gemDefinitionMirror, "value", DeclaredType.class);
        PackageElement pkg = this.processingEnv.getElementUtils().getPackageOf(definingElement);
        String gemName = this.util.getSimpleName(gemDeclaredType);
        String gemFqn = this.util.getFullyQualifiedName(gemDeclaredType);
        String gemPackage = pkg.getQualifiedName().toString();
        List<ExecutableElement> methods = ElementFilter.methodsIn(gemDeclaredType.asElement().getEnclosedElements());
        List<GemValueInfo> gemValueInfos = methods.stream().map(e -> new GemValueInfo(e.getSimpleName().toString(), e.getReturnType())).collect(Collectors.toList());
        GemInfo gemInfo = new GemInfo(gemPackage, gemName, gemFqn, gemValueInfos, definingElement, gemDeclaredType.asElement());
        this.gemInfos.add(gemInfo);
    }

    private void postProcessGemInfo() {
        for (GemInfo gemInfo : this.gemInfos) {
            for (GemValueInfo gemValueInfo : gemInfo.getGemValueInfos()) {
                if (TypeKind.ARRAY == gemValueInfo.getTypeMirror().getKind()) {
                    ArrayType arrayType = (ArrayType)gemValueInfo.getTypeMirror();
                    gemValueInfo.setValueType(this.getGemValueType(arrayType.getComponentType(), true));
                    continue;
                }
                gemValueInfo.setValueType(this.getGemValueType(gemValueInfo.getTypeMirror(), false));
            }
        }
    }

    private GemValueType getGemValueType(TypeMirror type, boolean isArray) {
        GemValueType valueType;
        switch (type.getKind()) {
            case DECLARED: {
                DeclaredType declaredType = (DeclaredType)type;
                String fqn = this.util.getFullyQualifiedName(declaredType);
                if (this.util.isEnumeration(declaredType)) {
                    valueType = new GemValueType(String.class, true, isArray);
                    break;
                }
                if (Class.class.getName().equals(fqn)) {
                    valueType = new GemValueType(TypeMirror.class, false, isArray);
                    break;
                }
                if (String.class.getName().equals(fqn)) {
                    valueType = new GemValueType(String.class, false, isArray);
                    break;
                }
                GemInfo usedGem = this.gemInfos.stream().filter(g -> fqn.equals(g.getAnnotationFqn())).findFirst().orElse(null);
                if (usedGem != null) {
                    valueType = new GemValueType(usedGem, isArray);
                    break;
                }
                valueType = new GemValueType(TypeMirror.class, false, isArray);
                break;
            }
            case BOOLEAN: {
                valueType = new GemValueType(Boolean.class, false, isArray);
                break;
            }
            case BYTE: {
                valueType = new GemValueType(Byte.class, false, isArray);
                break;
            }
            case CHAR: {
                valueType = new GemValueType(Character.class, false, isArray);
                break;
            }
            case SHORT: {
                valueType = new GemValueType(Short.class, false, isArray);
                break;
            }
            case INT: {
                valueType = new GemValueType(Integer.class, false, isArray);
                break;
            }
            case LONG: {
                valueType = new GemValueType(Long.class, false, isArray);
                break;
            }
            case FLOAT: {
                valueType = new GemValueType(Float.class, false, isArray);
                break;
            }
            case DOUBLE: {
                valueType = new GemValueType(Double.class, false, isArray);
                break;
            }
            default: {
                throw new IllegalArgumentException("unrecognized annotation type");
            }
        }
        return valueType;
    }

    private void write() {
        for (GemInfo gemInfo : this.gemInfos) {
            try {
                Writer writer = this.processingEnv.getFiler().createSourceFile(gemInfo.getGemPackageName() + "." + gemInfo.getGemName(), gemInfo.getOriginatingElements()).openWriter();
                try {
                    Configuration cfg = new Configuration(new Version("2.3.21"));
                    cfg.setClassForTemplateLoading(GemProcessor.class, "/");
                    cfg.setDefaultEncoding("UTF-8");
                    HashMap<String, GemInfo> templateData = new HashMap<String, GemInfo>();
                    templateData.put("gemInfo", gemInfo);
                    Template template = cfg.getTemplate("org/mapstruct/tools/gem/processor/Gem.ftl");
                    template.process(templateData, writer);
                }
                finally {
                    if (writer == null) continue;
                    writer.close();
                }
            }
            catch (IOException | TemplateException ex) {
                throw new IllegalStateException(ex);
            }
        }
        this.gemInfos.clear();
    }
}

