/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.tools.gem.processor;

import org.mapstruct.tools.gem.processor.GemInfo;

public class GemValueType {
    private final String name;
    private final String fqn;
    private final String pacakage;
    private final boolean isEnum;
    private final boolean isArray;
    private final boolean isGem;
    private String gemName;
    private String elementName;

    public GemValueType(GemInfo gemInfo, boolean isArray) {
        this.elementName = gemInfo.getGemName();
        this.name = isArray ? "List<" + this.elementName + ">" : this.elementName;
        this.fqn = gemInfo.getGemPackageName() + "." + gemInfo.getGemName();
        this.gemName = gemInfo.getGemName();
        this.pacakage = gemInfo.getGemPackageName();
        this.isEnum = false;
        this.isArray = isArray;
        this.isGem = true;
    }

    public GemValueType(Class clazz, boolean isEnum, boolean isArray) {
        this.elementName = clazz.getSimpleName();
        this.name = isArray ? "List<" + clazz.getSimpleName() + ">" : clazz.getSimpleName();
        this.fqn = clazz.getName();
        this.pacakage = clazz.getPackage().getName();
        this.isEnum = isEnum;
        this.isArray = isArray;
        this.isGem = false;
    }

    public String getFqn() {
        return this.fqn;
    }

    public String getPacakage() {
        return this.pacakage;
    }

    public String getName() {
        return this.name;
    }

    public String getElementName() {
        return this.elementName;
    }

    public boolean isEnum() {
        return this.isEnum;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public boolean isGem() {
        return this.isGem;
    }

    public String getGemName() {
        return this.gemName;
    }
}

