/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.tools.gem.processor.shaded.freemarker.cache;

import java.io.IOException;
import org.mapstruct.tools.gem.processor.shaded.freemarker.cache.TemplateSourceMatcher;

public class FileExtensionMatcher
extends TemplateSourceMatcher {
    private final String extension;
    private boolean caseInsensitive = true;

    public FileExtensionMatcher(String extension) {
        if (extension.indexOf(47) != -1) {
            throw new IllegalArgumentException("A file extension can't contain \"/\": " + extension);
        }
        if (extension.indexOf(42) != -1) {
            throw new IllegalArgumentException("A file extension can't contain \"*\": " + extension);
        }
        if (extension.indexOf(63) != -1) {
            throw new IllegalArgumentException("A file extension can't contain \"*\": " + extension);
        }
        if (extension.startsWith(".")) {
            throw new IllegalArgumentException("A file extension can't start with \".\": " + extension);
        }
        this.extension = extension;
    }

    public boolean matches(String sourceName, Object templateSource) throws IOException {
        int extLn;
        int ln = sourceName.length();
        if (ln < (extLn = this.extension.length()) + 1 || sourceName.charAt(ln - extLn - 1) != '.') {
            return false;
        }
        return sourceName.regionMatches(this.caseInsensitive, ln - extLn, this.extension, 0, extLn);
    }

    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }

    public FileExtensionMatcher caseInsensitive(boolean caseInsensitive) {
        this.setCaseInsensitive(caseInsensitive);
        return this;
    }
}

