/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.tools.gem.processor.shaded.freemarker.cache;

import java.io.IOException;
import org.mapstruct.tools.gem.processor.shaded.freemarker.cache.TemplateConfigurationFactory;
import org.mapstruct.tools.gem.processor.shaded.freemarker.cache.TemplateConfigurationFactoryException;
import org.mapstruct.tools.gem.processor.shaded.freemarker.core.TemplateConfiguration;
import org.mapstruct.tools.gem.processor.shaded.freemarker.template.Configuration;
import org.mapstruct.tools.gem.processor.shaded.freemarker.template.utility.StringUtil;

public class FirstMatchTemplateConfigurationFactory
extends TemplateConfigurationFactory {
    private final TemplateConfigurationFactory[] templateConfigurationFactories;
    private boolean allowNoMatch;
    private String noMatchErrorDetails;

    public FirstMatchTemplateConfigurationFactory(TemplateConfigurationFactory ... templateConfigurationFactories) {
        this.templateConfigurationFactories = templateConfigurationFactories;
    }

    public TemplateConfiguration get(String sourceName, Object templateSource) throws IOException, TemplateConfigurationFactoryException {
        for (TemplateConfigurationFactory tcf : this.templateConfigurationFactories) {
            TemplateConfiguration tc = tcf.get(sourceName, templateSource);
            if (tc == null) continue;
            return tc;
        }
        if (!this.allowNoMatch) {
            throw new TemplateConfigurationFactoryException(FirstMatchTemplateConfigurationFactory.class.getSimpleName() + " has found no matching choice for source name " + StringUtil.jQuote(sourceName) + ". " + (this.noMatchErrorDetails != null ? "Error details: " + this.noMatchErrorDetails : "(Set the noMatchErrorDetails property of the factory bean to give a more specific error message. Set allowNoMatch to true if this shouldn't be an error.)"));
        }
        return null;
    }

    public boolean getAllowNoMatch() {
        return this.allowNoMatch;
    }

    public void setAllowNoMatch(boolean allowNoMatch) {
        this.allowNoMatch = allowNoMatch;
    }

    public String getNoMatchErrorDetails() {
        return this.noMatchErrorDetails;
    }

    public void setNoMatchErrorDetails(String noMatchErrorDetails) {
        this.noMatchErrorDetails = noMatchErrorDetails;
    }

    public FirstMatchTemplateConfigurationFactory allowNoMatch(boolean allow) {
        this.setAllowNoMatch(allow);
        return this;
    }

    public FirstMatchTemplateConfigurationFactory noMatchErrorDetails(String message) {
        this.setNoMatchErrorDetails(message);
        return this;
    }

    protected void setConfigurationOfChildren(Configuration cfg) {
        for (TemplateConfigurationFactory templateConfigurationFactory : this.templateConfigurationFactories) {
            templateConfigurationFactory.setConfiguration(cfg);
        }
    }
}

