/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.tools.gem.processor.shaded.freemarker.cache;

import org.mapstruct.tools.gem.processor.shaded.freemarker.template.utility.NullArgumentException;

public abstract class TemplateLookupResult {
    static TemplateLookupResult createNegativeResult() {
        return NegativeTemplateLookupResult.INSTANCE;
    }

    static TemplateLookupResult from(String templateSourceName, Object templateSource) {
        return templateSource != null ? new PositiveTemplateLookupResult(templateSourceName, templateSource) : TemplateLookupResult.createNegativeResult();
    }

    private TemplateLookupResult() {
    }

    public abstract String getTemplateSourceName();

    public abstract boolean isPositive();

    abstract Object getTemplateSource();

    private static final class NegativeTemplateLookupResult
    extends TemplateLookupResult {
        private static final NegativeTemplateLookupResult INSTANCE = new NegativeTemplateLookupResult();

        private NegativeTemplateLookupResult() {
        }

        public String getTemplateSourceName() {
            return null;
        }

        Object getTemplateSource() {
            return null;
        }

        public boolean isPositive() {
            return false;
        }
    }

    private static final class PositiveTemplateLookupResult
    extends TemplateLookupResult {
        private final String templateSourceName;
        private final Object templateSource;

        private PositiveTemplateLookupResult(String templateSourceName, Object templateSource) {
            NullArgumentException.check("templateName", templateSourceName);
            NullArgumentException.check("templateSource", templateSource);
            if (templateSource instanceof TemplateLookupResult) {
                throw new IllegalArgumentException();
            }
            this.templateSourceName = templateSourceName;
            this.templateSource = templateSource;
        }

        public String getTemplateSourceName() {
            return this.templateSourceName;
        }

        Object getTemplateSource() {
            return this.templateSource;
        }

        public boolean isPositive() {
            return true;
        }
    }
}

