/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.tools.gem.processor.shaded.freemarker.core;

import java.util.List;
import org.mapstruct.tools.gem.processor.shaded.freemarker.core.BuiltInForNode;
import org.mapstruct.tools.gem.processor.shaded.freemarker.core.BuiltInForNodeEx;
import org.mapstruct.tools.gem.processor.shaded.freemarker.core.Environment;
import org.mapstruct.tools.gem.processor.shaded.freemarker.ext.dom._ExtDomApi;
import org.mapstruct.tools.gem.processor.shaded.freemarker.template.SimpleScalar;
import org.mapstruct.tools.gem.processor.shaded.freemarker.template.SimpleSequence;
import org.mapstruct.tools.gem.processor.shaded.freemarker.template.TemplateMethodModel;
import org.mapstruct.tools.gem.processor.shaded.freemarker.template.TemplateModel;
import org.mapstruct.tools.gem.processor.shaded.freemarker.template.TemplateModelException;
import org.mapstruct.tools.gem.processor.shaded.freemarker.template.TemplateNodeModel;
import org.mapstruct.tools.gem.processor.shaded.freemarker.template.TemplateNodeModelEx;

class BuiltInsForNodes {
    private BuiltInsForNodes() {
    }

    static class AncestorSequence
    extends SimpleSequence
    implements TemplateMethodModel {
        private Environment env;

        AncestorSequence(Environment env) {
            this.env = env;
        }

        public Object exec(List names) throws TemplateModelException {
            if (names == null || names.isEmpty()) {
                return this;
            }
            AncestorSequence result = new AncestorSequence(this.env);
            block0: for (int i = 0; i < this.size(); ++i) {
                TemplateNodeModel tnm = (TemplateNodeModel)this.get(i);
                String nodeName = tnm.getNodeName();
                String nsURI = tnm.getNodeNamespace();
                if (nsURI == null) {
                    if (!names.contains(nodeName)) continue;
                    result.add(tnm);
                    continue;
                }
                for (int j = 0; j < names.size(); ++j) {
                    if (!_ExtDomApi.matchesName((String)names.get(j), nodeName, nsURI, this.env)) continue;
                    result.add(tnm);
                    continue block0;
                }
            }
            return result;
        }
    }

    static class nextSiblingBI
    extends BuiltInForNodeEx {
        nextSiblingBI() {
        }

        TemplateModel calculateResult(TemplateNodeModelEx nodeModel, Environment env) throws TemplateModelException {
            return nodeModel.getNextSibling();
        }
    }

    static class previousSiblingBI
    extends BuiltInForNodeEx {
        previousSiblingBI() {
        }

        TemplateModel calculateResult(TemplateNodeModelEx nodeModel, Environment env) throws TemplateModelException {
            return nodeModel.getPreviousSibling();
        }
    }

    static class rootBI
    extends BuiltInForNode {
        rootBI() {
        }

        TemplateModel calculateResult(TemplateNodeModel nodeModel, Environment env) throws TemplateModelException {
            TemplateNodeModel result = nodeModel;
            TemplateNodeModel parent = nodeModel.getParentNode();
            while (parent != null) {
                result = parent;
                parent = result.getParentNode();
            }
            return result;
        }
    }

    static class parentBI
    extends BuiltInForNode {
        parentBI() {
        }

        TemplateModel calculateResult(TemplateNodeModel nodeModel, Environment env) throws TemplateModelException {
            return nodeModel.getParentNode();
        }
    }

    static class node_typeBI
    extends BuiltInForNode {
        node_typeBI() {
        }

        TemplateModel calculateResult(TemplateNodeModel nodeModel, Environment env) throws TemplateModelException {
            return new SimpleScalar(nodeModel.getNodeType());
        }
    }

    static class node_namespaceBI
    extends BuiltInForNode {
        node_namespaceBI() {
        }

        TemplateModel calculateResult(TemplateNodeModel nodeModel, Environment env) throws TemplateModelException {
            String nsURI = nodeModel.getNodeNamespace();
            return nsURI == null ? null : new SimpleScalar(nsURI);
        }
    }

    static class node_nameBI
    extends BuiltInForNode {
        node_nameBI() {
        }

        TemplateModel calculateResult(TemplateNodeModel nodeModel, Environment env) throws TemplateModelException {
            return new SimpleScalar(nodeModel.getNodeName());
        }
    }

    static class childrenBI
    extends BuiltInForNode {
        childrenBI() {
        }

        TemplateModel calculateResult(TemplateNodeModel nodeModel, Environment env) throws TemplateModelException {
            return nodeModel.getChildNodes();
        }
    }

    static class ancestorsBI
    extends BuiltInForNode {
        ancestorsBI() {
        }

        TemplateModel calculateResult(TemplateNodeModel nodeModel, Environment env) throws TemplateModelException {
            AncestorSequence result = new AncestorSequence(env);
            for (TemplateNodeModel parent = nodeModel.getParentNode(); parent != null; parent = parent.getParentNode()) {
                result.add(parent);
            }
            return result;
        }
    }
}

