/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.tools.gem.processor.shaded.freemarker.core;

import java.io.IOException;
import java.io.Writer;
import org.mapstruct.tools.gem.processor.shaded.freemarker.core.Environment;
import org.mapstruct.tools.gem.processor.shaded.freemarker.core.EvalUtil;
import org.mapstruct.tools.gem.processor.shaded.freemarker.core.Expression;
import org.mapstruct.tools.gem.processor.shaded.freemarker.core.Interpolation;
import org.mapstruct.tools.gem.processor.shaded.freemarker.core.MarkupOutputFormat;
import org.mapstruct.tools.gem.processor.shaded.freemarker.core.OutputFormat;
import org.mapstruct.tools.gem.processor.shaded.freemarker.core.ParameterRole;
import org.mapstruct.tools.gem.processor.shaded.freemarker.core.TemplateElement;
import org.mapstruct.tools.gem.processor.shaded.freemarker.core.TemplateMarkupOutputModel;
import org.mapstruct.tools.gem.processor.shaded.freemarker.core._DelayedToString;
import org.mapstruct.tools.gem.processor.shaded.freemarker.core._TemplateModelException;
import org.mapstruct.tools.gem.processor.shaded.freemarker.template.TemplateException;
import org.mapstruct.tools.gem.processor.shaded.freemarker.template.utility.StringUtil;

final class DollarVariable
extends Interpolation {
    private final Expression expression;
    private final Expression escapedExpression;
    private final OutputFormat outputFormat;
    private final MarkupOutputFormat markupOutputFormat;
    private final boolean autoEscape;

    DollarVariable(Expression expression, Expression escapedExpression, OutputFormat outputFormat, boolean autoEscape) {
        this.expression = expression;
        this.escapedExpression = escapedExpression;
        this.outputFormat = outputFormat;
        this.markupOutputFormat = (MarkupOutputFormat)(outputFormat instanceof MarkupOutputFormat ? outputFormat : null);
        this.autoEscape = autoEscape;
    }

    TemplateElement[] accept(Environment env) throws TemplateException, IOException {
        Object moOrStr = this.calculateInterpolatedStringOrMarkup(env);
        Writer out = env.getOut();
        if (moOrStr instanceof String) {
            String s = (String)moOrStr;
            if (this.autoEscape) {
                this.markupOutputFormat.output(s, out);
            } else {
                out.write(s);
            }
        } else {
            TemplateMarkupOutputModel mo = (TemplateMarkupOutputModel)moOrStr;
            MarkupOutputFormat<TemplateMarkupOutputModel> moOF = mo.getOutputFormat();
            if (moOF != this.outputFormat && !this.outputFormat.isOutputFormatMixingAllowed()) {
                String srcPlainText = moOF.getSourcePlainText(mo);
                if (srcPlainText == null) {
                    throw new _TemplateModelException(this.escapedExpression, "The value to print is in ", new _DelayedToString(moOF), " format, which differs from the current output format, ", new _DelayedToString(this.outputFormat), ". Format conversion wasn't possible.");
                }
                if (this.outputFormat instanceof MarkupOutputFormat) {
                    ((MarkupOutputFormat)this.outputFormat).output(srcPlainText, out);
                } else {
                    out.write(srcPlainText);
                }
            } else {
                moOF.output(mo, out);
            }
        }
        return null;
    }

    protected Object calculateInterpolatedStringOrMarkup(Environment env) throws TemplateException {
        return EvalUtil.coerceModelToStringOrMarkup(this.escapedExpression.eval(env), this.escapedExpression, null, env);
    }

    protected String dump(boolean canonical, boolean inStringLiteral) {
        StringBuilder sb = new StringBuilder();
        int syntax = this.getTemplate().getInterpolationSyntax();
        sb.append(syntax != 22 ? "${" : "[=");
        String exprCF = this.expression.getCanonicalForm();
        sb.append(inStringLiteral ? StringUtil.FTLStringLiteralEnc(exprCF, '\"') : exprCF);
        sb.append(syntax != 22 ? "}" : "]");
        if (!canonical && this.expression != this.escapedExpression) {
            sb.append(" auto-escaped");
        }
        return sb.toString();
    }

    String getNodeTypeSymbol() {
        return "${...}";
    }

    boolean heedsOpeningWhitespace() {
        return true;
    }

    boolean heedsTrailingWhitespace() {
        return true;
    }

    int getParameterCount() {
        return 1;
    }

    Object getParameterValue(int idx) {
        if (idx != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.expression;
    }

    ParameterRole getParameterRole(int idx) {
        if (idx != 0) {
            throw new IndexOutOfBoundsException();
        }
        return ParameterRole.CONTENT;
    }

    boolean isNestedBlockRepeater() {
        return false;
    }
}

