/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.tools.gem.processor.shaded.freemarker.core;

import java.io.IOException;
import java.io.Writer;
import org.mapstruct.tools.gem.processor.shaded.freemarker.core.CommonMarkupOutputFormat;
import org.mapstruct.tools.gem.processor.shaded.freemarker.core.TemplateHTMLOutputModel;
import org.mapstruct.tools.gem.processor.shaded.freemarker.template.TemplateModelException;
import org.mapstruct.tools.gem.processor.shaded.freemarker.template.utility.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLOutputFormat
extends CommonMarkupOutputFormat<TemplateHTMLOutputModel> {
    public static final HTMLOutputFormat INSTANCE = new HTMLOutputFormat();

    protected HTMLOutputFormat() {
    }

    @Override
    public String getName() {
        return "HTML";
    }

    @Override
    public String getMimeType() {
        return "text/html";
    }

    @Override
    public void output(String textToEsc, Writer out) throws IOException, TemplateModelException {
        StringUtil.XHTMLEnc(textToEsc, out);
    }

    @Override
    public String escapePlainText(String plainTextContent) {
        return StringUtil.XHTMLEnc(plainTextContent);
    }

    @Override
    public boolean isLegacyBuiltInBypassed(String builtInName) {
        return builtInName.equals("html") || builtInName.equals("xml") || builtInName.equals("xhtml");
    }

    @Override
    protected TemplateHTMLOutputModel newTemplateMarkupOutputModel(String plainTextContent, String markupContent) {
        return new TemplateHTMLOutputModel(plainTextContent, markupContent);
    }
}

