/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.tools.gem.processor.shaded.freemarker.core;

import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import java.util.Map;
import org.mapstruct.tools.gem.processor.shaded.freemarker.core.DynamicKeyName;
import org.mapstruct.tools.gem.processor.shaded.freemarker.core.Environment;
import org.mapstruct.tools.gem.processor.shaded.freemarker.core.Expression;
import org.mapstruct.tools.gem.processor.shaded.freemarker.core.NumberLiteral;
import org.mapstruct.tools.gem.processor.shaded.freemarker.core.OutputFormatBoundBuiltIn;
import org.mapstruct.tools.gem.processor.shaded.freemarker.core.ParserConfiguration;
import org.mapstruct.tools.gem.processor.shaded.freemarker.core.UnexpectedTypeException;
import org.mapstruct.tools.gem.processor.shaded.freemarker.core._DelayedGetMessage;
import org.mapstruct.tools.gem.processor.shaded.freemarker.core._MiscTemplateException;
import org.mapstruct.tools.gem.processor.shaded.freemarker.core._ParserConfigurationWithInheritedFormat;
import org.mapstruct.tools.gem.processor.shaded.freemarker.core._TemplateModelException;
import org.mapstruct.tools.gem.processor.shaded.freemarker.template.Template;
import org.mapstruct.tools.gem.processor.shaded.freemarker.template.TemplateException;
import org.mapstruct.tools.gem.processor.shaded.freemarker.template.TemplateModel;
import org.mapstruct.tools.gem.processor.shaded.freemarker.template.TemplateModelException;
import org.mapstruct.tools.gem.processor.shaded.freemarker.template.TemplateScalarModel;
import org.mapstruct.tools.gem.processor.shaded.freemarker.template.TemplateSequenceModel;
import org.mapstruct.tools.gem.processor.shaded.freemarker.template.TemplateTransformModel;
import org.mapstruct.tools.gem.processor.shaded.freemarker.template._TemplateAPI;

class Interpret
extends OutputFormatBoundBuiltIn {
    Interpret() {
    }

    protected TemplateModel calculateResult(Environment env) throws TemplateException {
        Template interpretedTemplate;
        TemplateModel model = this.target.eval(env);
        Expression sourceExpr = null;
        String id = "anonymous_interpreted";
        if (model instanceof TemplateSequenceModel) {
            sourceExpr = (Expression)new DynamicKeyName(this.target, new NumberLiteral(0)).copyLocationFrom(this.target);
            if (((TemplateSequenceModel)model).size() > 1) {
                id = ((Expression)new DynamicKeyName(this.target, new NumberLiteral(1)).copyLocationFrom(this.target)).evalAndCoerceToPlainText(env);
            }
        } else if (model instanceof TemplateScalarModel) {
            sourceExpr = this.target;
        } else {
            throw new UnexpectedTypeException(this.target, model, "sequence or string", new Class[]{TemplateSequenceModel.class, TemplateScalarModel.class}, env);
        }
        String templateSource = sourceExpr.evalAndCoerceToPlainText(env);
        Template parentTemplate = env.getConfiguration().getIncompatibleImprovements().intValue() >= _TemplateAPI.VERSION_INT_2_3_26 ? env.getCurrentTemplate() : env.getTemplate();
        try {
            ParserConfiguration pCfg = parentTemplate.getParserConfiguration();
            if (pCfg.getOutputFormat() != this.outputFormat) {
                pCfg = new _ParserConfigurationWithInheritedFormat(pCfg, this.outputFormat, this.autoEscapingPolicy);
            }
            interpretedTemplate = new Template((parentTemplate.getName() != null ? parentTemplate.getName() : "nameless_template") + "->" + id, null, new StringReader(templateSource), parentTemplate.getConfiguration(), pCfg, null);
        }
        catch (IOException e) {
            throw new _MiscTemplateException((Expression)this, (Throwable)e, env, "Template parsing with \"?", this.key, "\" has failed with this error:\n\n", "---begin-message---\n", new _DelayedGetMessage(e), "\n---end-message---", "\n\nThe failed expression:");
        }
        interpretedTemplate.setLocale(env.getLocale());
        return new TemplateProcessorModel(interpretedTemplate);
    }

    private class TemplateProcessorModel
    implements TemplateTransformModel {
        private final Template template;

        TemplateProcessorModel(Template template) {
            this.template = template;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Writer getWriter(final Writer out, Map args) throws TemplateModelException, IOException {
            try {
                Environment env = Environment.getCurrentEnvironment();
                boolean lastFIRE = env.setFastInvalidReferenceExceptions(false);
                try {
                    env.include(this.template);
                }
                finally {
                    env.setFastInvalidReferenceExceptions(lastFIRE);
                }
            }
            catch (Exception e) {
                throw new _TemplateModelException((Throwable)e, "Template created with \"?", Interpret.this.key, "\" has stopped with this error:\n\n", "---begin-message---\n", new _DelayedGetMessage(e), "\n---end-message---");
            }
            return new Writer(out){

                public void close() {
                }

                public void flush() throws IOException {
                    out.flush();
                }

                public void write(char[] cbuf, int off, int len) throws IOException {
                    out.write(cbuf, off, len);
                }
            };
        }
    }
}

