/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.tools.gem.processor.shaded.freemarker.core;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.mapstruct.tools.gem.processor.shaded.freemarker.core.TemplateDateFormat;
import org.mapstruct.tools.gem.processor.shaded.freemarker.core.TemplateFormatUtil;
import org.mapstruct.tools.gem.processor.shaded.freemarker.core.UnparsableValueException;
import org.mapstruct.tools.gem.processor.shaded.freemarker.template.TemplateDateModel;
import org.mapstruct.tools.gem.processor.shaded.freemarker.template.TemplateModelException;

class JavaTemplateDateFormat
extends TemplateDateFormat {
    private final DateFormat javaDateFormat;

    public JavaTemplateDateFormat(DateFormat javaDateFormat) {
        this.javaDateFormat = javaDateFormat;
    }

    public String formatToPlainText(TemplateDateModel dateModel) throws TemplateModelException {
        return this.javaDateFormat.format(TemplateFormatUtil.getNonNullDate(dateModel));
    }

    public Date parse(String s, int dateType) throws UnparsableValueException {
        try {
            return this.javaDateFormat.parse(s);
        }
        catch (ParseException e) {
            throw new UnparsableValueException(e.getMessage(), e);
        }
    }

    public String getDescription() {
        return this.javaDateFormat instanceof SimpleDateFormat ? ((SimpleDateFormat)this.javaDateFormat).toPattern() : this.javaDateFormat.toString();
    }

    public boolean isLocaleBound() {
        return true;
    }

    public boolean isTimeZoneBound() {
        return true;
    }
}

