/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.tools.gem.processor.shaded.freemarker.core;

import java.util.List;
import org.mapstruct.tools.gem.processor.shaded.freemarker.core.Environment;
import org.mapstruct.tools.gem.processor.shaded.freemarker.core.Expression;
import org.mapstruct.tools.gem.processor.shaded.freemarker.core.Identifier;
import org.mapstruct.tools.gem.processor.shaded.freemarker.core.NullTemplateModel;
import org.mapstruct.tools.gem.processor.shaded.freemarker.core.ParameterRole;
import org.mapstruct.tools.gem.processor.shaded.freemarker.core.Token;
import org.mapstruct.tools.gem.processor.shaded.freemarker.template.TemplateException;
import org.mapstruct.tools.gem.processor.shaded.freemarker.template.TemplateModel;

final class LocalLambdaExpression
extends Expression {
    private final LambdaParameterList lho;
    private final Expression rho;

    LocalLambdaExpression(LambdaParameterList lho, Expression rho) {
        this.lho = lho;
        this.rho = rho;
    }

    public String getCanonicalForm() {
        return this.lho.getCanonicalForm() + " -> " + this.rho.getCanonicalForm();
    }

    String getNodeTypeSymbol() {
        return "->";
    }

    TemplateModel _eval(Environment env) throws TemplateException {
        throw new TemplateException("Can't get lambda expression as a value: Lambdas currently can only be used on a few special places.", env);
    }

    TemplateModel invokeLambdaDefinedFunction(TemplateModel argValue, Environment env) throws TemplateException {
        return env.evaluateWithNewLocal(this.rho, this.lho.getParameters().get(0).getName(), argValue != null ? argValue : NullTemplateModel.INSTANCE);
    }

    boolean isLiteral() {
        return false;
    }

    protected Expression deepCloneWithIdentifierReplaced_inner(String replacedIdentifier, Expression replacement, Expression.ReplacemenetState replacementState) {
        return new LocalLambdaExpression(this.lho, this.rho.deepCloneWithIdentifierReplaced(replacedIdentifier, replacement, replacementState));
    }

    int getParameterCount() {
        return 2;
    }

    Object getParameterValue(int idx) {
        switch (idx) {
            case 0: {
                return this.lho;
            }
            case 1: {
                return this.rho;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    ParameterRole getParameterRole(int idx) {
        return ParameterRole.forBinaryOperatorOperand(idx);
    }

    LambdaParameterList getLambdaParameterList() {
        return this.lho;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LambdaParameterList {
        private final Token openingParenthesis;
        private final Token closingParenthesis;
        private final List<Identifier> parameters;

        public LambdaParameterList(Token openingParenthesis, List<Identifier> parameters, Token closingParenthesis) {
            this.openingParenthesis = openingParenthesis;
            this.closingParenthesis = closingParenthesis;
            this.parameters = parameters;
        }

        public Token getOpeningParenthesis() {
            return this.openingParenthesis;
        }

        public Token getClosingParenthesis() {
            return this.closingParenthesis;
        }

        public List<Identifier> getParameters() {
            return this.parameters;
        }

        public String getCanonicalForm() {
            if (this.parameters.size() == 1) {
                return this.parameters.get(0).getCanonicalForm();
            }
            StringBuilder sb = new StringBuilder();
            sb.append('(');
            for (int i = 0; i < this.parameters.size(); ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                Identifier parameter = this.parameters.get(i);
                sb.append(parameter.getCanonicalForm());
            }
            sb.append(')');
            return sb.toString();
        }
    }
}

