/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.tools.gem.processor.shaded.freemarker.core;

import org.mapstruct.tools.gem.processor.shaded.freemarker.core.Environment;
import org.mapstruct.tools.gem.processor.shaded.freemarker.core.Expression;
import org.mapstruct.tools.gem.processor.shaded.freemarker.core.ParameterRole;
import org.mapstruct.tools.gem.processor.shaded.freemarker.template.SimpleNumber;
import org.mapstruct.tools.gem.processor.shaded.freemarker.template.TemplateException;
import org.mapstruct.tools.gem.processor.shaded.freemarker.template.TemplateModel;
import org.mapstruct.tools.gem.processor.shaded.freemarker.template.TemplateNumberModel;

final class NumberLiteral
extends Expression
implements TemplateNumberModel {
    private final Number value;

    public NumberLiteral(Number value) {
        this.value = value;
    }

    TemplateModel _eval(Environment env) {
        return new SimpleNumber(this.value);
    }

    public String evalAndCoerceToPlainText(Environment env) throws TemplateException {
        return env.formatNumberToPlainText(this, this, false);
    }

    public Number getAsNumber() {
        return this.value;
    }

    String getName() {
        return "the number: '" + this.value + "'";
    }

    public String getCanonicalForm() {
        return this.value.toString();
    }

    String getNodeTypeSymbol() {
        return this.getCanonicalForm();
    }

    boolean isLiteral() {
        return true;
    }

    protected Expression deepCloneWithIdentifierReplaced_inner(String replacedIdentifier, Expression replacement, Expression.ReplacemenetState replacementState) {
        return new NumberLiteral(this.value);
    }

    int getParameterCount() {
        return 0;
    }

    Object getParameterValue(int idx) {
        throw new IndexOutOfBoundsException();
    }

    ParameterRole getParameterRole(int idx) {
        throw new IndexOutOfBoundsException();
    }
}

