/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.tools.gem.processor.shaded.freemarker.core;

import java.io.IOException;
import java.io.Writer;
import org.mapstruct.tools.gem.processor.shaded.freemarker.core.CommonMarkupOutputFormat;
import org.mapstruct.tools.gem.processor.shaded.freemarker.core.TemplateRTFOutputModel;
import org.mapstruct.tools.gem.processor.shaded.freemarker.template.TemplateModelException;
import org.mapstruct.tools.gem.processor.shaded.freemarker.template.utility.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RTFOutputFormat
extends CommonMarkupOutputFormat<TemplateRTFOutputModel> {
    public static final RTFOutputFormat INSTANCE = new RTFOutputFormat();

    protected RTFOutputFormat() {
    }

    @Override
    public String getName() {
        return "RTF";
    }

    @Override
    public String getMimeType() {
        return "application/rtf";
    }

    @Override
    public void output(String textToEsc, Writer out) throws IOException, TemplateModelException {
        StringUtil.RTFEnc(textToEsc, out);
    }

    @Override
    public String escapePlainText(String plainTextContent) {
        return StringUtil.RTFEnc(plainTextContent);
    }

    @Override
    public boolean isLegacyBuiltInBypassed(String builtInName) {
        return builtInName.equals("rtf");
    }

    @Override
    protected TemplateRTFOutputModel newTemplateMarkupOutputModel(String plainTextContent, String markupContent) {
        return new TemplateRTFOutputModel(plainTextContent, markupContent);
    }
}

