/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.tools.gem.processor.shaded.freemarker.core;

import java.io.IOException;
import org.mapstruct.tools.gem.processor.shaded.freemarker.core.Environment;
import org.mapstruct.tools.gem.processor.shaded.freemarker.core.FlowControlException;
import org.mapstruct.tools.gem.processor.shaded.freemarker.core.ParameterRole;
import org.mapstruct.tools.gem.processor.shaded.freemarker.core.ParseException;
import org.mapstruct.tools.gem.processor.shaded.freemarker.core.TemplateElement;
import org.mapstruct.tools.gem.processor.shaded.freemarker.core.TemplatePostProcessor;
import org.mapstruct.tools.gem.processor.shaded.freemarker.core.TemplatePostProcessorException;
import org.mapstruct.tools.gem.processor.shaded.freemarker.template.Template;
import org.mapstruct.tools.gem.processor.shaded.freemarker.template.TemplateException;

class ThreadInterruptionSupportTemplatePostProcessor
extends TemplatePostProcessor {
    ThreadInterruptionSupportTemplatePostProcessor() {
    }

    public void postProcess(Template t) throws TemplatePostProcessorException {
        TemplateElement te = t.getRootTreeNode();
        this.addInterruptionChecks(te);
    }

    private void addInterruptionChecks(TemplateElement te) throws TemplatePostProcessorException {
        if (te == null) {
            return;
        }
        int childCount = te.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            this.addInterruptionChecks(te.getChild(i));
        }
        if (te.isNestedBlockRepeater()) {
            try {
                te.addChild(0, new ThreadInterruptionCheck(te));
            }
            catch (ParseException e) {
                throw new TemplatePostProcessorException("Unexpected error; see cause", e);
            }
        }
    }

    static class TemplateProcessingThreadInterruptedException
    extends FlowControlException {
        TemplateProcessingThreadInterruptedException() {
            super("Template processing thread \"interrupted\" flag was set.");
        }
    }

    static class ThreadInterruptionCheck
    extends TemplateElement {
        private ThreadInterruptionCheck(TemplateElement te) throws ParseException {
            this.setLocation(te.getTemplate(), te.beginColumn, te.beginLine, te.beginColumn, te.beginLine);
        }

        TemplateElement[] accept(Environment env) throws TemplateException, IOException {
            if (Thread.currentThread().isInterrupted()) {
                throw new TemplateProcessingThreadInterruptedException();
            }
            return null;
        }

        protected String dump(boolean canonical) {
            return canonical ? "" : "<#--" + this.getNodeTypeSymbol() + "--#>";
        }

        String getNodeTypeSymbol() {
            return "##threadInterruptionCheck";
        }

        int getParameterCount() {
            return 0;
        }

        Object getParameterValue(int idx) {
            throw new IndexOutOfBoundsException();
        }

        ParameterRole getParameterRole(int idx) {
            throw new IndexOutOfBoundsException();
        }

        boolean isNestedBlockRepeater() {
            return false;
        }
    }
}

