/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.tools.gem.processor.shaded.freemarker.ext.beans;

import java.lang.reflect.Array;
import org.mapstruct.tools.gem.processor.shaded.freemarker.ext.beans.BeanModel;
import org.mapstruct.tools.gem.processor.shaded.freemarker.ext.beans.BeansWrapper;
import org.mapstruct.tools.gem.processor.shaded.freemarker.ext.util.ModelFactory;
import org.mapstruct.tools.gem.processor.shaded.freemarker.template.ObjectWrapper;
import org.mapstruct.tools.gem.processor.shaded.freemarker.template.TemplateCollectionModel;
import org.mapstruct.tools.gem.processor.shaded.freemarker.template.TemplateModel;
import org.mapstruct.tools.gem.processor.shaded.freemarker.template.TemplateModelException;
import org.mapstruct.tools.gem.processor.shaded.freemarker.template.TemplateModelIterator;
import org.mapstruct.tools.gem.processor.shaded.freemarker.template.TemplateSequenceModel;

public class ArrayModel
extends BeanModel
implements TemplateCollectionModel,
TemplateSequenceModel {
    static final ModelFactory FACTORY = new ModelFactory(){

        public TemplateModel create(Object object, ObjectWrapper wrapper) {
            return new ArrayModel(object, (BeansWrapper)wrapper);
        }
    };
    private final int length;

    public ArrayModel(Object array, BeansWrapper wrapper) {
        super(array, wrapper);
        Class<?> clazz = array.getClass();
        if (!clazz.isArray()) {
            throw new IllegalArgumentException("Object is not an array, it's " + array.getClass().getName());
        }
        this.length = Array.getLength(array);
    }

    public TemplateModelIterator iterator() {
        return new Iterator();
    }

    public TemplateModel get(int index) throws TemplateModelException {
        try {
            return this.wrap(Array.get(this.object, index));
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public int size() {
        return this.length;
    }

    public boolean isEmpty() {
        return this.length == 0;
    }

    private class Iterator
    implements TemplateSequenceModel,
    TemplateModelIterator {
        private int position = 0;

        private Iterator() {
        }

        public boolean hasNext() {
            return this.position < ArrayModel.this.length;
        }

        public TemplateModel get(int index) throws TemplateModelException {
            return ArrayModel.this.get(index);
        }

        public TemplateModel next() throws TemplateModelException {
            return this.position < ArrayModel.this.length ? this.get(this.position++) : null;
        }

        public int size() {
            return ArrayModel.this.size();
        }
    }
}

