/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.tools.gem.processor.shaded.freemarker.ext.beans;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.mapstruct.tools.gem.processor.shaded.freemarker.ext.beans.BeansWrapper;
import org.mapstruct.tools.gem.processor.shaded.freemarker.ext.beans.ClassIntrospector;
import org.mapstruct.tools.gem.processor.shaded.freemarker.template.utility.ClassUtil;

class UnsafeMethods {
    private static final String UNSAFE_METHODS_PROPERTIES = "unsafeMethods.properties";
    private static final Set UNSAFE_METHODS = UnsafeMethods.createUnsafeMethodsSet();

    private UnsafeMethods() {
    }

    static boolean isUnsafeMethod(Method method) {
        return UNSAFE_METHODS.contains(method);
    }

    private static final Set createUnsafeMethodsSet() {
        try {
            Properties props = ClassUtil.loadProperties(BeansWrapper.class, UNSAFE_METHODS_PROPERTIES);
            HashSet<Method> set = new HashSet<Method>(props.size() * 4 / 3, 1.0f);
            Map primClasses = UnsafeMethods.createPrimitiveClassesMap();
            for (Object key : props.keySet()) {
                try {
                    set.add(UnsafeMethods.parseMethodSpec((String)key, primClasses));
                }
                catch (ClassNotFoundException e) {
                    if (!ClassIntrospector.DEVELOPMENT_MODE) continue;
                    throw e;
                }
                catch (NoSuchMethodException e) {
                    if (!ClassIntrospector.DEVELOPMENT_MODE) continue;
                    throw e;
                }
            }
            return set;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load unsafe method set", e);
        }
    }

    private static Method parseMethodSpec(String methodSpec, Map primClasses) throws ClassNotFoundException, NoSuchMethodException {
        int brace = methodSpec.indexOf(40);
        int dot = methodSpec.lastIndexOf(46, brace);
        Class clazz = ClassUtil.forName(methodSpec.substring(0, dot));
        String methodName = methodSpec.substring(dot + 1, brace);
        String argSpec = methodSpec.substring(brace + 1, methodSpec.length() - 1);
        StringTokenizer tok = new StringTokenizer(argSpec, ",");
        int argcount = tok.countTokens();
        Class[] argTypes = new Class[argcount];
        for (int i = 0; i < argcount; ++i) {
            String argClassName = tok.nextToken();
            argTypes[i] = (Class)primClasses.get(argClassName);
            if (argTypes[i] != null) continue;
            argTypes[i] = ClassUtil.forName(argClassName);
        }
        return clazz.getMethod(methodName, argTypes);
    }

    private static Map createPrimitiveClassesMap() {
        HashMap<String, Class<Comparable<Boolean>>> map = new HashMap<String, Class<Comparable<Boolean>>>();
        map.put("boolean", Boolean.TYPE);
        map.put("byte", Byte.TYPE);
        map.put("char", Character.TYPE);
        map.put("short", Short.TYPE);
        map.put("int", Integer.TYPE);
        map.put("long", Long.TYPE);
        map.put("float", Float.TYPE);
        map.put("double", Double.TYPE);
        return map;
    }
}

