/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.web;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.mitre.oauth2.model.ClientDetailsEntity;
import org.mitre.oauth2.model.SystemScope;
import org.mitre.oauth2.service.ClientDetailsEntityService;
import org.mitre.oauth2.service.SystemScopeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.SessionAttributes;

@Controller
@SessionAttributes(value={"authorizationRequest"})
public class OAuthConfirmationController {
    @Autowired
    private ClientDetailsEntityService clientService;
    @Autowired
    private SystemScopeService scopeService;
    private static Logger logger = LoggerFactory.getLogger(OAuthConfirmationController.class);

    public OAuthConfirmationController() {
    }

    public OAuthConfirmationController(ClientDetailsEntityService clientService) {
        this.clientService = clientService;
    }

    @PreAuthorize(value="hasRole('ROLE_USER')")
    @RequestMapping(value={"/oauth/confirm_access"})
    public String confimAccess(Map<String, Object> model, @ModelAttribute(value="authorizationRequest") AuthorizationRequest clientAuth) {
        String prompt = (String)clientAuth.getExtensions().get("prompt");
        if ("none".equals(prompt)) {
            logger.info("Client requested no prompt, returning 403 from confirmation endpoint");
            model.put("code", HttpStatus.FORBIDDEN);
            return "httpCodeView";
        }
        ClientDetailsEntity client = null;
        try {
            client = this.clientService.loadClientByClientId(clientAuth.getClientId());
        }
        catch (OAuth2Exception e) {
            logger.error("confirmAccess: OAuth2Exception was thrown when attempting to load client", (Throwable)e);
            model.put("code", HttpStatus.BAD_REQUEST);
            return "httpCodeView";
        }
        catch (IllegalArgumentException e) {
            logger.error("confirmAccess: IllegalArgumentException was thrown when attempting to load client", (Throwable)e);
            model.put("code", HttpStatus.BAD_REQUEST);
            return "httpCodeView";
        }
        if (client == null) {
            logger.error("confirmAccess: could not find client " + clientAuth.getClientId());
            model.put("code", HttpStatus.NOT_FOUND);
            return "httpCodeView";
        }
        model.put("auth_request", clientAuth);
        model.put("client", client);
        String redirect_uri = clientAuth.getRedirectUri();
        model.put("redirect_uri", redirect_uri);
        Set scopes = this.scopeService.fromStrings(clientAuth.getScope());
        LinkedHashSet<SystemScope> sortedScopes = new LinkedHashSet<SystemScope>(scopes.size());
        Set systemScopes = this.scopeService.getAll();
        for (SystemScope s : systemScopes) {
            if (!scopes.contains(s)) continue;
            sortedScopes.add(s);
        }
        sortedScopes.addAll((Collection<SystemScope>)Sets.difference((Set)scopes, (Set)systemScopes));
        model.put("scopes", sortedScopes);
        return "approve";
    }

    public ClientDetailsEntityService getClientService() {
        return this.clientService;
    }

    public void setClientService(ClientDetailsEntityService clientService) {
        this.clientService = clientService;
    }
}

