/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.web;

import java.security.Principal;
import java.util.Set;
import org.mitre.oauth2.model.OAuth2RefreshTokenEntity;
import org.mitre.oauth2.service.OAuth2TokenEntityService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public class RefreshTokenAPI {
    @Autowired
    private OAuth2TokenEntityService tokenService;
    private static Logger logger = LoggerFactory.getLogger(RefreshTokenAPI.class);

    @RequestMapping(value={""}, method={RequestMethod.GET}, produces={"application/json"})
    public String getAll(ModelMap m, Principal p) {
        Set allTokens = this.tokenService.getAllRefreshTokensForUser(p.getName());
        m.put((Object)"entity", (Object)allTokens);
        return "jsonEntityView";
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET}, produces={"application/json"})
    public String getById(@PathVariable(value="id") Long id, ModelMap m, Principal p) {
        OAuth2RefreshTokenEntity token = this.tokenService.getRefreshTokenById(id);
        if (token == null) {
            logger.error("getToken failed; token not found: " + id);
            m.put((Object)"code", (Object)HttpStatus.NOT_FOUND);
            m.put((Object)"errorMessage", (Object)("The requested token with id " + id + " could not be found."));
            return "jsonErrorView";
        }
        if (!token.getAuthenticationHolder().getAuthentication().getName().equals(p.getName())) {
            logger.error("getToken failed; token does not belong to principal " + p.getName());
            m.put((Object)"code", (Object)HttpStatus.FORBIDDEN);
            m.put((Object)"errorMessage", (Object)"You do not have permission to view this token");
            return "jsonErrorView";
        }
        m.put((Object)"entity", (Object)token);
        return "jsonEntityView";
    }
}

