/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.assertion;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.ReadOnlyJWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.text.ParseException;
import java.util.Date;
import org.mitre.jwt.signer.service.JwtSigningAndValidationService;
import org.mitre.jwt.signer.service.impl.JWKSetCacheService;
import org.mitre.oauth2.model.ClientDetailsEntity;
import org.mitre.oauth2.service.ClientDetailsEntityService;
import org.mitre.openid.connect.assertion.JwtBearerAssertionAuthenticationToken;
import org.mitre.openid.connect.config.ConfigurationPropertiesBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.oauth2.common.exceptions.InvalidClientException;

public class JwtBearerAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger logger = LoggerFactory.getLogger(JwtBearerAuthenticationProvider.class);
    @Autowired
    private JWKSetCacheService validators;
    private int timeSkewAllowance = 300;
    @Autowired
    private ClientDetailsEntityService clientService;
    @Autowired
    private ConfigurationPropertiesBean config;

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        JwtBearerAssertionAuthenticationToken jwtAuth = (JwtBearerAssertionAuthenticationToken)authentication;
        try {
            ClientDetailsEntity client = this.clientService.loadClientByClientId(jwtAuth.getClientId());
            JWT jwt = jwtAuth.getJwt();
            ReadOnlyJWTClaimsSet jwtClaims = jwt.getJWTClaimsSet();
            if (jwt instanceof SignedJWT) {
                SignedJWT jws = (SignedJWT)jwt;
                JwtSigningAndValidationService validator = this.validators.getValidator(client.getJwksUri());
                if (validator == null || !validator.validateSignature(jws)) {
                    throw new AuthenticationServiceException("Invalid signature");
                }
            }
            if (jwtClaims.getIssuer() == null) {
                throw new AuthenticationServiceException("Assertion Token Issuer is null");
            }
            if (!jwtClaims.getIssuer().equals(client.getClientId())) {
                throw new AuthenticationServiceException("Issuers do not match, expected " + client.getClientId() + " got " + jwtClaims.getIssuer());
            }
            if (jwtClaims.getExpirationTime() == null) {
                throw new AuthenticationServiceException("Assertion Token does not have required expiration claim");
            }
            Date now = new Date(System.currentTimeMillis() - (long)(this.timeSkewAllowance * 1000));
            if (now.after(jwtClaims.getExpirationTime())) {
                throw new AuthenticationServiceException("Assertion Token is expired: " + jwtClaims.getExpirationTime());
            }
            if (jwtClaims.getNotBeforeTime() != null && (now = new Date(System.currentTimeMillis() + (long)(this.timeSkewAllowance * 1000))).before(jwtClaims.getNotBeforeTime())) {
                throw new AuthenticationServiceException("Assertion Token not valid untill: " + jwtClaims.getNotBeforeTime());
            }
            if (jwtClaims.getIssueTime() != null && (now = new Date(System.currentTimeMillis() + (long)(this.timeSkewAllowance * 1000))).before(jwtClaims.getIssueTime())) {
                throw new AuthenticationServiceException("Assertion Token was issued in the future: " + jwtClaims.getIssueTime());
            }
            if (jwtClaims.getAudience() == null) {
                throw new AuthenticationServiceException("Assertion token audience is null");
            }
            if (!jwtClaims.getAudience().contains(this.config.getIssuer())) {
                throw new AuthenticationServiceException("Audience does not match, expected " + this.config.getIssuer() + " got " + jwtClaims.getAudience());
            }
            return new JwtBearerAssertionAuthenticationToken(client.getClientId(), jwt, client.getAuthorities());
        }
        catch (InvalidClientException e) {
            throw new UsernameNotFoundException("Could not find client: " + jwtAuth.getClientId());
        }
        catch (ParseException e) {
            logger.error("Failure during authentication, error was: ", (Throwable)e);
            throw new AuthenticationServiceException("Invalid JWT format");
        }
    }

    public boolean supports(Class<?> authentication) {
        return JwtBearerAssertionAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

