/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.repository.impl;

import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.mitre.openid.connect.model.DefaultUserInfo;
import org.mitre.openid.connect.model.UserInfo;
import org.mitre.openid.connect.repository.UserInfoRepository;
import org.mitre.util.jpa.JpaUtil;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class JpaUserInfoRepository
implements UserInfoRepository {
    @PersistenceContext
    private EntityManager manager;

    @Transactional
    public UserInfo getBySubject(String sub) {
        TypedQuery query = this.manager.createNamedQuery("DefaultUserInfo.getBySubject", DefaultUserInfo.class);
        query.setParameter("sub", (Object)sub);
        return (UserInfo)JpaUtil.getSingleResult((List)query.getResultList());
    }

    @Transactional
    public UserInfo save(UserInfo userInfo) {
        DefaultUserInfo dui = (DefaultUserInfo)userInfo;
        return (UserInfo)JpaUtil.saveOrUpdate((Object)dui.getId(), (EntityManager)this.manager, (Object)dui);
    }

    @Transactional
    public void remove(UserInfo userInfo) {
        DefaultUserInfo dui = (DefaultUserInfo)userInfo;
        UserInfo found = (UserInfo)this.manager.find(DefaultUserInfo.class, (Object)dui.getId());
        if (found == null) {
            throw new IllegalArgumentException();
        }
        this.manager.remove((Object)userInfo);
    }

    @Transactional
    public Collection<DefaultUserInfo> getAll() {
        TypedQuery query = this.manager.createNamedQuery("DefaultUserInfo.getAll", DefaultUserInfo.class);
        return query.getResultList();
    }

    public UserInfo getByUsername(String username) {
        TypedQuery query = this.manager.createNamedQuery("DefaultUserInfo.getByUsername", DefaultUserInfo.class);
        query.setParameter("username", (Object)username);
        return (UserInfo)JpaUtil.getSingleResult((List)query.getResultList());
    }
}

