/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.token;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.mitre.oauth2.model.SystemScope;
import org.mitre.oauth2.service.SystemScopeService;
import org.mitre.openid.connect.model.ApprovedSite;
import org.mitre.openid.connect.model.WhitelistedSite;
import org.mitre.openid.connect.service.ApprovedSiteService;
import org.mitre.openid.connect.service.WhitelistedSiteService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.approval.UserApprovalHandler;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component(value="tofuUserApprovalHandler")
public class TofuUserApprovalHandler
implements UserApprovalHandler {
    @Autowired
    private ApprovedSiteService approvedSiteService;
    @Autowired
    private WhitelistedSiteService whitelistedSiteService;
    @Autowired
    private ClientDetailsService clientDetailsService;
    @Autowired
    private SystemScopeService systemScopes;

    public boolean isApproved(AuthorizationRequest authorizationRequest, Authentication userAuthentication) {
        if (authorizationRequest.isApproved()) {
            return true;
        }
        boolean approved = Boolean.parseBoolean((String)authorizationRequest.getApprovalParameters().get("user_oauth_approval"));
        return userAuthentication.isAuthenticated() && approved;
    }

    public AuthorizationRequest checkForPreApproval(AuthorizationRequest authorizationRequest, Authentication userAuthentication) {
        String userId = userAuthentication.getName();
        String clientId = authorizationRequest.getClientId();
        boolean alreadyApproved = false;
        String prompt = (String)authorizationRequest.getExtensions().get("prompt");
        if (!"consent".equals(prompt)) {
            WhitelistedSite ws;
            Collection aps = this.approvedSiteService.getByClientIdAndUserId(clientId, userId);
            for (ApprovedSite ap : aps) {
                if (ap.isExpired() || !this.systemScopes.scopesMatch(ap.getAllowedScopes(), authorizationRequest.getScope())) continue;
                ap.setAccessDate(new Date());
                this.approvedSiteService.save(ap);
                authorizationRequest.getExtensions().put("approved_site", ap.getId());
                authorizationRequest.setApproved(true);
                alreadyApproved = true;
                this.setAuthTime(authorizationRequest);
            }
            if (!alreadyApproved && (ws = this.whitelistedSiteService.getByClientId(clientId)) != null && this.systemScopes.scopesMatch(ws.getAllowedScopes(), authorizationRequest.getScope())) {
                ApprovedSite newSite = this.approvedSiteService.createApprovedSite(clientId, userId, null, ws.getAllowedScopes(), ws);
                authorizationRequest.getExtensions().put("approved_site", newSite.getId());
                authorizationRequest.setApproved(true);
                this.setAuthTime(authorizationRequest);
            }
        }
        return authorizationRequest;
    }

    public AuthorizationRequest updateAfterApproval(AuthorizationRequest authorizationRequest, Authentication userAuthentication) {
        String userId = userAuthentication.getName();
        String clientId = authorizationRequest.getClientId();
        ClientDetails client = this.clientDetailsService.loadClientByClientId(clientId);
        boolean approved = Boolean.parseBoolean((String)authorizationRequest.getApprovalParameters().get("user_oauth_approval"));
        if (approved) {
            authorizationRequest.setApproved(true);
            HashSet allowedScopes = Sets.newHashSet();
            Map approvalParams = authorizationRequest.getApprovalParameters();
            Set keys = approvalParams.keySet();
            for (String key : keys) {
                if (!key.startsWith("scope_")) continue;
                String scope = (String)approvalParams.get(key);
                HashSet approveSet = Sets.newHashSet((Object[])new String[]{scope});
                if (!this.systemScopes.scopesMatch(client.getScope(), (Set)approveSet)) continue;
                SystemScope systemScope = this.systemScopes.getByValue(scope);
                if (systemScope.isStructured()) {
                    String paramValue = (String)approvalParams.get("scopeparam_" + scope);
                    allowedScopes.add(scope + ":" + paramValue);
                    continue;
                }
                allowedScopes.add(scope);
            }
            authorizationRequest.setScope((Collection)allowedScopes);
            String remember = (String)authorizationRequest.getApprovalParameters().get("remember");
            if (!Strings.isNullOrEmpty((String)remember) && !remember.equals("none")) {
                Date timeout = null;
                if (remember.equals("one-hour")) {
                    Calendar cal = Calendar.getInstance();
                    cal.add(10, 1);
                    timeout = cal.getTime();
                }
                ApprovedSite newSite = this.approvedSiteService.createApprovedSite(clientId, userId, timeout, (Set)allowedScopes, null);
                authorizationRequest.getExtensions().put("approved_site", newSite.getId());
            }
            this.setAuthTime(authorizationRequest);
        }
        return authorizationRequest;
    }

    private void setAuthTime(AuthorizationRequest authorizationRequest) {
        Date authTime;
        HttpSession session;
        ServletRequestAttributes attr = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        if (attr != null && (session = attr.getRequest().getSession()) != null && (authTime = (Date)session.getAttribute("AUTH_TIMESTAMP")) != null) {
            authorizationRequest.getExtensions().put("AUTH_TIMESTAMP", authTime);
        }
    }
}

