/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.view;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mitre.oauth2.model.RegisteredClient;
import org.mitre.openid.connect.ClientDetailsEntityJsonProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.view.AbstractView;

@Component(value="clientInformationResponseView")
public class ClientInformationResponseView
extends AbstractView {
    private static Logger logger = LoggerFactory.getLogger(ClientInformationResponseView.class);
    private Gson gson = new Gson();

    protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) {
        response.setContentType("application/json");
        RegisteredClient c = (RegisteredClient)model.get("client");
        HttpStatus code = (HttpStatus)model.get("code");
        if (code == null) {
            code = HttpStatus.OK;
        }
        JsonObject o = ClientDetailsEntityJsonProcessor.serialize((RegisteredClient)c);
        try {
            PrintWriter out = response.getWriter();
            this.gson.toJson((JsonElement)o, (Appendable)out);
        }
        catch (JsonIOException e) {
            logger.error("JsonIOException in ClientInformationResponseView.java: ", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("IOException in ClientInformationResponseView.java: ", (Throwable)e);
        }
    }
}

