/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.repository.impl;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.mitre.oauth2.model.AuthenticationHolderEntity;
import org.mitre.oauth2.repository.AuthenticationHolderRepository;
import org.mitre.util.jpa.JpaUtil;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class JpaAuthenticationHolderRepository
implements AuthenticationHolderRepository {
    private static final int MAXEXPIREDRESULTS = 1000;
    @PersistenceContext
    private EntityManager manager;

    public List<AuthenticationHolderEntity> getAll() {
        TypedQuery query = this.manager.createNamedQuery("AuthenticationHolderEntity.getAll", AuthenticationHolderEntity.class);
        return query.getResultList();
    }

    public AuthenticationHolderEntity getById(Long id) {
        return (AuthenticationHolderEntity)this.manager.find(AuthenticationHolderEntity.class, (Object)id);
    }

    public AuthenticationHolderEntity getByAuthentication(OAuth2Authentication a) {
        TypedQuery query = this.manager.createNamedQuery("AuthenticationHolderEntity.getByAuthentication", AuthenticationHolderEntity.class);
        query.setParameter("authentication", (Object)a);
        return (AuthenticationHolderEntity)JpaUtil.getSingleResult((List)query.getResultList());
    }

    @Transactional
    public void removeById(Long id) {
        AuthenticationHolderEntity found = this.getById(id);
        if (found == null) {
            throw new IllegalArgumentException("AuthenticationHolderEntity not found: " + id);
        }
        this.manager.remove((Object)found);
    }

    @Transactional
    public void remove(AuthenticationHolderEntity a) {
        AuthenticationHolderEntity found = this.getById(a.getId());
        if (found == null) {
            throw new IllegalArgumentException("AuthenticationHolderEntity not found: " + a);
        }
        this.manager.remove((Object)found);
    }

    @Transactional
    public AuthenticationHolderEntity save(AuthenticationHolderEntity a) {
        return (AuthenticationHolderEntity)JpaUtil.saveOrUpdate((Object)a.getId(), (EntityManager)this.manager, (Object)a);
    }

    @Transactional
    public List<AuthenticationHolderEntity> getOrphanedAuthenticationHolders() {
        TypedQuery query = this.manager.createNamedQuery("AuthenticationHolderEntity.getUnusedAuthenticationHolders", AuthenticationHolderEntity.class);
        query.setMaxResults(1000);
        List unusedAuthenticationHolders = query.getResultList();
        return unusedAuthenticationHolders;
    }
}

