/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.service.impl;

import org.mitre.openid.connect.service.BlacklistedSiteService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.oauth2.common.exceptions.InvalidRequestException;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.endpoint.DefaultRedirectResolver;
import org.springframework.stereotype.Component;

@Component(value="blacklistAwareRedirectResolver")
public class BlacklistAwareRedirectResolver
extends DefaultRedirectResolver {
    @Autowired
    private BlacklistedSiteService blacklistService;

    public String resolveRedirect(String requestedRedirect, ClientDetails client) throws OAuth2Exception {
        String redirect = super.resolveRedirect(requestedRedirect, client);
        if (this.blacklistService.isBlacklisted(redirect)) {
            throw new InvalidRequestException("The supplied redirect_uri is not allowed on this server.");
        }
        return redirect;
    }
}

