/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.web;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.security.Principal;
import java.util.Set;
import org.mitre.oauth2.model.ClientDetailsEntity;
import org.mitre.oauth2.model.OAuth2AccessTokenEntity;
import org.mitre.oauth2.model.OAuth2RefreshTokenEntity;
import org.mitre.oauth2.service.ClientDetailsEntityService;
import org.mitre.oauth2.service.IntrospectionAuthorizer;
import org.mitre.oauth2.service.OAuth2TokenEntityService;
import org.mitre.openid.connect.model.UserInfo;
import org.mitre.openid.connect.service.UserInfoService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class IntrospectionEndpoint {
    @Autowired
    private OAuth2TokenEntityService tokenServices;
    @Autowired
    private ClientDetailsEntityService clientService;
    @Autowired
    private IntrospectionAuthorizer introspectionAuthorizer;
    @Autowired
    private UserInfoService userInfoService;
    private static Logger logger = LoggerFactory.getLogger(IntrospectionEndpoint.class);

    public IntrospectionEndpoint() {
    }

    public IntrospectionEndpoint(OAuth2TokenEntityService tokenServices) {
        this.tokenServices = tokenServices;
    }

    @PreAuthorize(value="hasRole('ROLE_CLIENT')")
    @RequestMapping(value={"/introspect"})
    public String verify(@RequestParam(value="token") String tokenValue, @RequestParam(value="resource_id", required=false) String resourceId, @RequestParam(value="token_type_hint", required=false) String tokenType, Principal p, Model model) {
        if (Strings.isNullOrEmpty((String)tokenValue)) {
            logger.error("Verify failed; token value is null");
            ImmutableMap entity = ImmutableMap.of((Object)"active", (Object)Boolean.FALSE);
            model.addAttribute("entity", (Object)entity);
            return "jsonEntityView";
        }
        String clientId = p.getName();
        ClientDetailsEntity authClient = this.clientService.loadClientByClientId(clientId);
        ClientDetailsEntity tokenClient = null;
        Set scopes = null;
        OAuth2AccessTokenEntity token = null;
        UserInfo user = null;
        try {
            OAuth2AccessTokenEntity access = this.tokenServices.readAccessToken(tokenValue);
            tokenClient = access.getClient();
            scopes = access.getScope();
            token = access;
            user = this.userInfoService.getByUsernameAndClientId(access.getAuthenticationHolder().getAuthentication().getName(), tokenClient.getClientId());
        }
        catch (InvalidTokenException e) {
            logger.error("Verify failed; Invalid access token. Checking refresh token.", (Throwable)e);
            try {
                OAuth2RefreshTokenEntity refresh = this.tokenServices.getRefreshToken(tokenValue);
                tokenClient = refresh.getClient();
                scopes = refresh.getAuthenticationHolder().getAuthentication().getOAuth2Request().getScope();
                user = this.userInfoService.getByUsernameAndClientId(refresh.getAuthenticationHolder().getAuthentication().getName(), tokenClient.getClientId());
                token = refresh;
            }
            catch (InvalidTokenException e2) {
                logger.error("Verify failed; Invalid refresh token", (Throwable)e2);
                ImmutableMap entity = ImmutableMap.of((Object)"active", (Object)Boolean.FALSE);
                model.addAttribute("entity", (Object)entity);
                return "jsonEntityView";
            }
        }
        if (tokenClient != null && authClient != null) {
            if (authClient.isAllowIntrospection()) {
                if (this.introspectionAuthorizer.isIntrospectionPermitted((ClientDetails)authClient, (ClientDetails)tokenClient, scopes)) {
                    model.addAttribute("token", (Object)token);
                    model.addAttribute("user", (Object)user);
                    return "tokenIntrospection";
                }
                logger.error("Verify failed; client configuration or scope don't permit token introspection");
                model.addAttribute("code", (Object)HttpStatus.FORBIDDEN);
                return "httpCodeView";
            }
            logger.error("Verify failed; client " + clientId + " is not allowed to call introspection endpoint");
            model.addAttribute("code", (Object)HttpStatus.FORBIDDEN);
            return "httpCodeView";
        }
        logger.error("Verify failed; client " + clientId + " not found.");
        model.addAttribute("code", (Object)HttpStatus.NOT_FOUND);
        return "httpCodeView";
    }
}

