/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.service.impl;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.HashMultiset;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.mitre.oauth2.model.ClientDetailsEntity;
import org.mitre.oauth2.service.ClientDetailsEntityService;
import org.mitre.openid.connect.model.ApprovedSite;
import org.mitre.openid.connect.service.ApprovedSiteService;
import org.mitre.openid.connect.service.StatsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultStatsService
implements StatsService {
    @Autowired
    private ApprovedSiteService approvedSiteService;
    @Autowired
    private ClientDetailsEntityService clientService;
    private Supplier<Map<String, Integer>> summaryCache = this.createSummaryCache();
    private Supplier<Map<Long, Integer>> byClientIdCache = this.createByClientIdCache();

    private Supplier<Map<String, Integer>> createSummaryCache() {
        return Suppliers.memoizeWithExpiration((Supplier)new Supplier<Map<String, Integer>>(){

            public Map<String, Integer> get() {
                return DefaultStatsService.this.computeSummaryStats();
            }
        }, (long)10L, (TimeUnit)TimeUnit.MINUTES);
    }

    private Supplier<Map<Long, Integer>> createByClientIdCache() {
        return Suppliers.memoizeWithExpiration((Supplier)new Supplier<Map<Long, Integer>>(){

            public Map<Long, Integer> get() {
                return DefaultStatsService.this.computeByClientId();
            }
        }, (long)10L, (TimeUnit)TimeUnit.MINUTES);
    }

    public Map<String, Integer> getSummaryStats() {
        return (Map)this.summaryCache.get();
    }

    private Map<String, Integer> computeSummaryStats() {
        Collection allSites = this.approvedSiteService.getAll();
        HashSet<String> userIds = new HashSet<String>();
        HashSet<String> clientIds = new HashSet<String>();
        for (ApprovedSite approvedSite : allSites) {
            userIds.add(approvedSite.getUserId());
            clientIds.add(approvedSite.getClientId());
        }
        HashMap<String, Integer> e = new HashMap<String, Integer>();
        e.put("approvalCount", allSites.size());
        e.put("userCount", userIds.size());
        e.put("clientCount", clientIds.size());
        return e;
    }

    public Map<Long, Integer> getByClientId() {
        return (Map)this.byClientIdCache.get();
    }

    private Map<Long, Integer> computeByClientId() {
        Collection allSites = this.approvedSiteService.getAll();
        HashMultiset clientIds = HashMultiset.create();
        for (ApprovedSite approvedSite : allSites) {
            clientIds.add((Object)approvedSite.getClientId());
        }
        Map<Long, Integer> counts = this.getEmptyClientCountMap();
        for (String clientId : clientIds) {
            ClientDetailsEntity client = this.clientService.loadClientByClientId(clientId);
            counts.put(client.getId(), clientIds.count((Object)clientId));
        }
        return counts;
    }

    public Integer getCountForClientId(Long id) {
        Map<Long, Integer> counts = this.getByClientId();
        return counts.get(id);
    }

    private Map<Long, Integer> getEmptyClientCountMap() {
        HashMap<Long, Integer> counts = new HashMap<Long, Integer>();
        Collection clients = this.clientService.getAllClients();
        for (ClientDetailsEntity client : clients) {
            counts.put(client.getId(), 0);
        }
        return counts;
    }

    public void resetCache() {
        this.summaryCache = this.createSummaryCache();
        this.byClientIdCache = this.createByClientIdCache();
    }
}

