/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.view;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mitre.openid.connect.model.UserInfo;
import org.mitre.openid.connect.service.ScopeClaimTranslationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.web.servlet.view.AbstractView;

@Component(value="userInfoView")
public class UserInfoView
extends AbstractView {
    private static JsonParser jsonParser = new JsonParser();
    public static final String VIEWNAME = "userInfoView";
    private static Logger logger = LoggerFactory.getLogger(UserInfoView.class);
    @Autowired
    private ScopeClaimTranslationService translator;
    protected Gson gson = new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new ExclusionStrategy(){

        public boolean shouldSkipField(FieldAttributes f) {
            return false;
        }

        public boolean shouldSkipClass(Class<?> clazz) {
            return clazz.equals(BeanPropertyBindingResult.class);
        }
    }}).create();

    protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) {
        UserInfo userInfo = (UserInfo)model.get("userInfo");
        Set scope = (Set)model.get("scope");
        response.setContentType("application/json");
        JsonObject authorizedClaims = null;
        JsonObject requestedClaims = null;
        if (model.get("authorizedClaims") != null) {
            authorizedClaims = jsonParser.parse((String)model.get("authorizedClaims")).getAsJsonObject();
        }
        if (model.get("requestedClaims") != null) {
            requestedClaims = jsonParser.parse((String)model.get("requestedClaims")).getAsJsonObject();
        }
        JsonObject json = this.toJsonFromRequestObj(userInfo, scope, authorizedClaims, requestedClaims);
        this.writeOut(json, model, request, response);
    }

    protected void writeOut(JsonObject json, Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) {
        try {
            PrintWriter out = response.getWriter();
            this.gson.toJson((JsonElement)json, (Appendable)out);
        }
        catch (IOException e) {
            logger.error("IOException in UserInfoView.java: ", (Throwable)e);
        }
    }

    private JsonObject toJsonFromRequestObj(UserInfo ui, Set<String> scope, JsonObject authorizedClaims, JsonObject requestedClaims) {
        JsonObject obj = ui.toJson();
        Set allowedByScope = this.translator.getClaimsForScopeSet(scope);
        HashSet authorizedByClaims = new HashSet();
        HashSet requestedByClaims = new HashSet();
        if (authorizedClaims != null) {
            JsonObject userinfoAuthorized = authorizedClaims.getAsJsonObject().get("userinfo").getAsJsonObject();
            for (Map.Entry entry : userinfoAuthorized.getAsJsonObject().entrySet()) {
                authorizedByClaims.add(entry.getKey());
            }
        }
        if (requestedClaims != null) {
            JsonObject userinfoRequested = requestedClaims.getAsJsonObject().get("userinfo").getAsJsonObject();
            for (Map.Entry entry : userinfoRequested.getAsJsonObject().entrySet()) {
                requestedByClaims.add(entry.getKey());
            }
        }
        JsonObject result = new JsonObject();
        for (Map.Entry entry : obj.entrySet()) {
            if (!allowedByScope.contains(entry.getKey()) && !authorizedByClaims.contains(entry.getKey()) || !requestedByClaims.isEmpty() && !requestedByClaims.contains(entry.getKey())) continue;
            result.add((String)entry.getKey(), (JsonElement)entry.getValue());
        }
        return result;
    }
}

