/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.service.impl;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.text.DateFormatter;
import org.mitre.oauth2.model.OAuth2AccessTokenEntity;
import org.mitre.oauth2.model.OAuth2RefreshTokenEntity;
import org.mitre.oauth2.service.IntrospectionResultAssembler;
import org.mitre.openid.connect.model.UserInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.stereotype.Service;

@Service
public class DefaultIntrospectionResultAssembler
implements IntrospectionResultAssembler {
    private static Logger log = LoggerFactory.getLogger(DefaultIntrospectionResultAssembler.class);
    private static DateFormatter dateFormat = new DateFormatter(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ"));

    public Map<String, Object> assembleFrom(OAuth2AccessTokenEntity accessToken, UserInfo userInfo) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        OAuth2Authentication authentication = accessToken.getAuthenticationHolder().getAuthentication();
        result.put("active", true);
        result.put("scope", Joiner.on((String)" ").join((Iterable)accessToken.getScope()));
        if (accessToken.getExpiration() != null) {
            try {
                result.put("expires_at", dateFormat.valueToString(accessToken.getExpiration()));
                result.put("exp", accessToken.getExpiration().getTime() / 1000L);
            }
            catch (ParseException e) {
                log.error("Parse exception in token introspection", (Throwable)e);
            }
        }
        if (userInfo != null) {
            result.put("sub", userInfo.getSub());
        } else {
            result.put("sub", authentication.getName());
        }
        result.put("user_id", authentication.getName());
        result.put("client_id", authentication.getOAuth2Request().getClientId());
        result.put("token_type", accessToken.getTokenType());
        return result;
    }

    public Map<String, Object> assembleFrom(OAuth2RefreshTokenEntity refreshToken, UserInfo userInfo) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        OAuth2Authentication authentication = refreshToken.getAuthenticationHolder().getAuthentication();
        result.put("active", true);
        result.put("scope", Joiner.on((String)" ").join((Iterable)authentication.getOAuth2Request().getScope()));
        if (refreshToken.getExpiration() != null) {
            try {
                result.put("expires_at", dateFormat.valueToString(refreshToken.getExpiration()));
                result.put("exp", refreshToken.getExpiration().getTime() / 1000L);
            }
            catch (ParseException e) {
                log.error("Parse exception in token introspection", (Throwable)e);
            }
        }
        if (userInfo != null) {
            result.put("sub", userInfo.getSub());
        } else {
            result.put("sub", authentication.getName());
        }
        result.put("user_id", authentication.getName());
        result.put("client_id", authentication.getOAuth2Request().getClientId());
        return result;
    }
}

