/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.service.impl;

import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.mitre.oauth2.model.ClientDetailsEntity;
import org.mitre.oauth2.repository.OAuth2ClientRepository;
import org.mitre.oauth2.repository.OAuth2TokenRepository;
import org.mitre.oauth2.service.ClientDetailsEntityService;
import org.mitre.oauth2.service.SystemScopeService;
import org.mitre.openid.connect.model.WhitelistedSite;
import org.mitre.openid.connect.service.ApprovedSiteService;
import org.mitre.openid.connect.service.BlacklistedSiteService;
import org.mitre.openid.connect.service.WhitelistedSiteService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.security.oauth2.common.exceptions.InvalidClientException;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class DefaultOAuth2ClientDetailsEntityService
implements ClientDetailsEntityService {
    private static Logger logger = LoggerFactory.getLogger(DefaultOAuth2ClientDetailsEntityService.class);
    @Autowired
    private OAuth2ClientRepository clientRepository;
    @Autowired
    private OAuth2TokenRepository tokenRepository;
    @Autowired
    private ApprovedSiteService approvedSiteService;
    @Autowired
    private WhitelistedSiteService whitelistedSiteService;
    @Autowired
    private BlacklistedSiteService blacklistedSiteService;
    @Autowired
    private SystemScopeService scopeService;
    private LoadingCache<String, List<String>> sectorRedirects = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).maximumSize(100L).build((CacheLoader)new SectorIdentifierLoader());

    public ClientDetailsEntity saveNewClient(ClientDetailsEntity client) {
        if (client.getId() != null) {
            throw new IllegalArgumentException("Tried to save a new client with an existing ID: " + client.getId());
        }
        if (client.getRegisteredRedirectUri() != null) {
            for (String uri : client.getRegisteredRedirectUri()) {
                if (!this.blacklistedSiteService.isBlacklisted(uri)) continue;
                throw new IllegalArgumentException("Client URI is blacklisted: " + uri);
            }
        }
        if (Strings.isNullOrEmpty((String)client.getClientId())) {
            client = this.generateClientId(client);
        }
        if (client.isAllowRefresh()) {
            client.getScope().add("offline_access");
        } else {
            client.getScope().remove("offline_access");
        }
        client.setCreatedAt(new Date());
        if (!Strings.isNullOrEmpty((String)client.getSectorIdentifierUri())) {
            try {
                List redirects = (List)this.sectorRedirects.get((Object)client.getSectorIdentifierUri());
                if (client.getRegisteredRedirectUri() != null) {
                    for (String uri : client.getRegisteredRedirectUri()) {
                        if (redirects.contains(uri)) continue;
                        throw new IllegalArgumentException("Requested Redirect URI " + uri + " is not listed at sector identifier " + redirects);
                    }
                }
            }
            catch (ExecutionException e) {
                throw new IllegalArgumentException("Unable to load sector identifier URI: " + client.getSectorIdentifierUri());
            }
        }
        client.setScope(this.scopeService.removeRestrictedScopes(client.getScope()));
        return this.clientRepository.saveClient(client);
    }

    public ClientDetailsEntity getClientById(Long id) {
        ClientDetailsEntity client = this.clientRepository.getById(id);
        return client;
    }

    public ClientDetailsEntity loadClientByClientId(String clientId) throws OAuth2Exception, InvalidClientException, IllegalArgumentException {
        if (!Strings.isNullOrEmpty((String)clientId)) {
            ClientDetailsEntity client = this.clientRepository.getClientByClientId(clientId);
            if (client == null) {
                throw new InvalidClientException("Client with id " + clientId + " was not found");
            }
            return client;
        }
        throw new IllegalArgumentException("Client id must not be empty!");
    }

    public void deleteClient(ClientDetailsEntity client) throws InvalidClientException {
        if (this.clientRepository.getById(client.getId()) == null) {
            throw new InvalidClientException("Client with id " + client.getClientId() + " was not found");
        }
        this.tokenRepository.clearTokensForClient(client);
        this.approvedSiteService.clearApprovedSitesForClient((ClientDetails)client);
        WhitelistedSite whitelistedSite = this.whitelistedSiteService.getByClientId(client.getClientId());
        if (whitelistedSite != null) {
            this.whitelistedSiteService.remove(whitelistedSite);
        }
        this.clientRepository.deleteClient(client);
    }

    public ClientDetailsEntity updateClient(ClientDetailsEntity oldClient, ClientDetailsEntity newClient) throws IllegalArgumentException {
        if (oldClient != null && newClient != null) {
            for (String uri : newClient.getRegisteredRedirectUri()) {
                if (!this.blacklistedSiteService.isBlacklisted(uri)) continue;
                throw new IllegalArgumentException("Client URI is blacklisted: " + uri);
            }
            if (newClient.isAllowRefresh()) {
                newClient.getScope().add("offline_access");
            } else {
                newClient.getScope().remove("offline_access");
            }
            if (!Strings.isNullOrEmpty((String)newClient.getSectorIdentifierUri())) {
                try {
                    List redirects = (List)this.sectorRedirects.get((Object)newClient.getSectorIdentifierUri());
                    if (newClient.getRegisteredRedirectUri() != null) {
                        for (String uri : newClient.getRegisteredRedirectUri()) {
                            if (redirects.contains(uri)) continue;
                            throw new IllegalArgumentException("Requested Redirect URI " + uri + " is not listed at sector identifier " + redirects);
                        }
                    }
                }
                catch (ExecutionException e) {
                    throw new IllegalArgumentException("Unable to load sector identifier URI: " + newClient.getSectorIdentifierUri());
                }
            }
            newClient.setScope(this.scopeService.removeRestrictedScopes(newClient.getScope()));
            return this.clientRepository.updateClient(oldClient.getId(), newClient);
        }
        throw new IllegalArgumentException("Neither old client or new client can be null!");
    }

    public Collection<ClientDetailsEntity> getAllClients() {
        return this.clientRepository.getAllClients();
    }

    public ClientDetailsEntity generateClientId(ClientDetailsEntity client) {
        client.setClientId(UUID.randomUUID().toString());
        return client;
    }

    public ClientDetailsEntity generateClientSecret(ClientDetailsEntity client) {
        client.setClientSecret(Base64.encodeBase64URLSafeString((byte[])new BigInteger(512, new SecureRandom()).toByteArray()).replace("=", ""));
        return client;
    }

    private class SectorIdentifierLoader
    extends CacheLoader<String, List<String>> {
        private HttpClient httpClient = new DefaultHttpClient();
        private HttpComponentsClientHttpRequestFactory httpFactory = new HttpComponentsClientHttpRequestFactory(this.httpClient);
        private RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)this.httpFactory);
        private JsonParser parser = new JsonParser();

        private SectorIdentifierLoader() {
        }

        public List<String> load(String key) throws Exception {
            String jsonString;
            JsonElement json;
            if (!key.startsWith("https")) {
                logger.error("Sector identifier doesn't start with https, loading anyway...");
            }
            if ((json = this.parser.parse(jsonString = (String)this.restTemplate.getForObject(key, String.class, new Object[0]))).isJsonArray()) {
                ArrayList<String> redirectUris = new ArrayList<String>();
                for (JsonElement el : json.getAsJsonArray()) {
                    redirectUris.add(el.getAsString());
                }
                logger.info("Found " + redirectUris + " for sector " + key);
                return redirectUris;
            }
            return null;
        }
    }
}

