/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.service.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.PlainJWT;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.mitre.oauth2.model.AuthenticationHolderEntity;
import org.mitre.oauth2.model.ClientDetailsEntity;
import org.mitre.oauth2.model.OAuth2AccessTokenEntity;
import org.mitre.oauth2.model.OAuth2RefreshTokenEntity;
import org.mitre.oauth2.repository.AuthenticationHolderRepository;
import org.mitre.oauth2.repository.OAuth2TokenRepository;
import org.mitre.oauth2.service.ClientDetailsEntityService;
import org.mitre.oauth2.service.OAuth2TokenEntityService;
import org.mitre.oauth2.service.SystemScopeService;
import org.mitre.openid.connect.model.ApprovedSite;
import org.mitre.openid.connect.service.ApprovedSiteService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.InvalidClientException;
import org.springframework.security.oauth2.common.exceptions.InvalidScopeException;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.TokenRequest;
import org.springframework.security.oauth2.provider.token.TokenEnhancer;
import org.springframework.stereotype.Service;

@Service
public class DefaultOAuth2ProviderTokenService
implements OAuth2TokenEntityService {
    private static Logger logger = LoggerFactory.getLogger(DefaultOAuth2ProviderTokenService.class);
    @Autowired
    private OAuth2TokenRepository tokenRepository;
    @Autowired
    private AuthenticationHolderRepository authenticationHolderRepository;
    @Autowired
    private ClientDetailsEntityService clientDetailsService;
    @Autowired
    private TokenEnhancer tokenEnhancer;
    @Autowired
    private SystemScopeService scopeService;
    @Autowired
    private ApprovedSiteService approvedSiteService;
    private Predicate<OAuth2AccessTokenEntity> isAccessTokenExpired = new Predicate<OAuth2AccessTokenEntity>(){

        public boolean apply(OAuth2AccessTokenEntity input) {
            return input != null && input.isExpired();
        }
    };
    private Predicate<OAuth2RefreshTokenEntity> isRefreshTokenExpired = new Predicate<OAuth2RefreshTokenEntity>(){

        public boolean apply(OAuth2RefreshTokenEntity input) {
            return input != null && input.isExpired();
        }
    };

    public Set<OAuth2AccessTokenEntity> getAllAccessTokensForUser(String id) {
        Set all = this.tokenRepository.getAllAccessTokens();
        LinkedHashSet results = Sets.newLinkedHashSet();
        for (OAuth2AccessTokenEntity token : all) {
            if (!token.getAuthenticationHolder().getAuthentication().getName().equals(id)) continue;
            results.add(token);
        }
        return results;
    }

    public Set<OAuth2RefreshTokenEntity> getAllRefreshTokensForUser(String id) {
        Set all = this.tokenRepository.getAllRefreshTokens();
        LinkedHashSet results = Sets.newLinkedHashSet();
        for (OAuth2RefreshTokenEntity token : all) {
            if (!token.getAuthenticationHolder().getAuthentication().getName().equals(id)) continue;
            results.add(token);
        }
        return results;
    }

    public OAuth2AccessTokenEntity getAccessTokenById(Long id) {
        return this.tokenRepository.getAccessTokenById(id);
    }

    public OAuth2RefreshTokenEntity getRefreshTokenById(Long id) {
        return this.tokenRepository.getRefreshTokenById(id);
    }

    public OAuth2AccessTokenEntity createAccessToken(OAuth2Authentication authentication) throws AuthenticationException, InvalidClientException {
        if (authentication != null && authentication.getOAuth2Request() != null) {
            OAuth2Request clientAuth = authentication.getOAuth2Request();
            ClientDetailsEntity client = this.clientDetailsService.loadClientByClientId(clientAuth.getClientId());
            if (client == null) {
                throw new InvalidClientException("Client not found: " + clientAuth.getClientId());
            }
            OAuth2AccessTokenEntity token = new OAuth2AccessTokenEntity();
            token.setClient(client);
            Set scopes = Sets.newHashSet((Iterable)clientAuth.getScope());
            scopes = this.scopeService.removeRestrictedScopes(scopes);
            token.setScope(scopes);
            if (client.getAccessTokenValiditySeconds() != null && client.getAccessTokenValiditySeconds() > 0) {
                Date expiration = new Date(System.currentTimeMillis() + (long)client.getAccessTokenValiditySeconds().intValue() * 1000L);
                token.setExpiration(expiration);
            }
            AuthenticationHolderEntity authHolder = new AuthenticationHolderEntity();
            authHolder.setAuthentication(authentication);
            authHolder = this.authenticationHolderRepository.save(authHolder);
            token.setAuthenticationHolder(authHolder);
            if (client.isAllowRefresh() && scopes.contains("offline_access")) {
                OAuth2RefreshTokenEntity refreshToken = new OAuth2RefreshTokenEntity();
                JWTClaimsSet refreshClaims = new JWTClaimsSet();
                if (client.getRefreshTokenValiditySeconds() != null) {
                    Date expiration = new Date(System.currentTimeMillis() + (long)client.getRefreshTokenValiditySeconds().intValue() * 1000L);
                    refreshToken.setExpiration(expiration);
                    refreshClaims.setExpirationTime(expiration);
                }
                refreshClaims.setJWTID(UUID.randomUUID().toString());
                PlainJWT refreshJwt = new PlainJWT(refreshClaims);
                refreshToken.setJwt((JWT)refreshJwt);
                refreshToken.setAuthenticationHolder(authHolder);
                refreshToken.setClient(client);
                this.tokenRepository.saveRefreshToken(refreshToken);
                token.setRefreshToken(refreshToken);
            }
            this.tokenEnhancer.enhance((OAuth2AccessToken)token, authentication);
            this.tokenRepository.saveAccessToken(token);
            OAuth2Request originalAuthRequest = authHolder.getAuthentication().getOAuth2Request();
            if (originalAuthRequest.getExtensions() != null && originalAuthRequest.getExtensions().containsKey("approved_site")) {
                Long apId = (Long)originalAuthRequest.getExtensions().get("approved_site");
                ApprovedSite ap = this.approvedSiteService.getById(apId);
                Set apTokens = ap.getApprovedAccessTokens();
                apTokens.add(token);
                ap.setApprovedAccessTokens(apTokens);
                this.approvedSiteService.save(ap);
            }
            if (token.getRefreshToken() != null) {
                this.tokenRepository.saveRefreshToken(token.getRefreshToken());
            }
            return token;
        }
        throw new AuthenticationCredentialsNotFoundException("No authentication credentials found");
    }

    /*
     * Enabled aggressive block sorting
     */
    public OAuth2AccessTokenEntity refreshAccessToken(String refreshTokenValue, TokenRequest authRequest) throws AuthenticationException {
        OAuth2AccessTokenEntity token;
        AuthenticationHolderEntity authHolder;
        ClientDetailsEntity client;
        OAuth2RefreshTokenEntity refreshToken;
        block7: {
            refreshToken = this.tokenRepository.getRefreshTokenByValue(refreshTokenValue);
            if (refreshToken == null) {
                throw new InvalidTokenException("Invalid refresh token: " + refreshTokenValue);
            }
            client = refreshToken.getClient();
            authHolder = refreshToken.getAuthenticationHolder();
            if (!client.isAllowRefresh()) {
                throw new InvalidClientException("Client does not allow refreshing access token!");
            }
            this.tokenRepository.clearAccessTokensForRefreshToken(refreshToken);
            if (refreshToken.isExpired()) {
                this.tokenRepository.removeRefreshToken(refreshToken);
                throw new InvalidTokenException("Expired refresh token: " + refreshTokenValue);
            }
            token = new OAuth2AccessTokenEntity();
            Set refreshScopes = new HashSet(refreshToken.getAuthenticationHolder().getAuthentication().getOAuth2Request().getScope());
            refreshScopes = this.scopeService.removeRestrictedScopes(refreshScopes);
            Set scope = authRequest.getScope() == null ? new HashSet() : new HashSet(authRequest.getScope());
            if ((scope = this.scopeService.removeRestrictedScopes(scope)) != null && !scope.isEmpty()) {
                if (refreshScopes != null && refreshScopes.containsAll(scope)) {
                    token.setScope(scope);
                    break block7;
                } else {
                    String errorMsg = "Up-scoping is not allowed.";
                    logger.error(errorMsg);
                    throw new InvalidScopeException(errorMsg);
                }
            }
            token.setScope(refreshScopes);
        }
        token.setClient(client);
        if (client.getAccessTokenValiditySeconds() != null) {
            Date expiration = new Date(System.currentTimeMillis() + (long)client.getAccessTokenValiditySeconds().intValue() * 1000L);
            token.setExpiration(expiration);
        }
        token.setRefreshToken(refreshToken);
        token.setAuthenticationHolder(authHolder);
        this.tokenEnhancer.enhance((OAuth2AccessToken)token, authHolder.getAuthentication());
        this.tokenRepository.saveAccessToken(token);
        return token;
    }

    public OAuth2Authentication loadAuthentication(String accessTokenValue) throws AuthenticationException {
        OAuth2AccessTokenEntity accessToken = this.tokenRepository.getAccessTokenByValue(accessTokenValue);
        if (accessToken == null) {
            throw new InvalidTokenException("Invalid access token: " + accessTokenValue);
        }
        if (accessToken.isExpired()) {
            this.revokeAccessToken(accessToken);
            throw new InvalidTokenException("Expired access token: " + accessTokenValue);
        }
        return accessToken.getAuthenticationHolder().getAuthentication();
    }

    public OAuth2AccessTokenEntity readAccessToken(String accessTokenValue) throws AuthenticationException {
        OAuth2AccessTokenEntity accessToken = this.tokenRepository.getAccessTokenByValue(accessTokenValue);
        if (accessToken == null) {
            throw new InvalidTokenException("Access token for value " + accessTokenValue + " was not found");
        }
        return accessToken;
    }

    public OAuth2AccessTokenEntity getAccessToken(OAuth2Authentication authentication) {
        OAuth2AccessTokenEntity accessToken = this.tokenRepository.getByAuthentication(authentication);
        return accessToken;
    }

    public OAuth2RefreshTokenEntity getRefreshToken(String refreshTokenValue) throws AuthenticationException {
        OAuth2RefreshTokenEntity refreshToken = this.tokenRepository.getRefreshTokenByValue(refreshTokenValue);
        if (refreshToken == null) {
            throw new InvalidTokenException("Refresh token for value " + refreshTokenValue + " was not found");
        }
        return refreshToken;
    }

    public void revokeRefreshToken(OAuth2RefreshTokenEntity refreshToken) {
        this.tokenRepository.clearAccessTokensForRefreshToken(refreshToken);
        this.tokenRepository.removeRefreshToken(refreshToken);
    }

    public void revokeAccessToken(OAuth2AccessTokenEntity accessToken) {
        this.tokenRepository.removeAccessToken(accessToken);
    }

    public List<OAuth2AccessTokenEntity> getAccessTokensForClient(ClientDetailsEntity client) {
        return this.tokenRepository.getAccessTokensForClient(client);
    }

    public List<OAuth2RefreshTokenEntity> getRefreshTokensForClient(ClientDetailsEntity client) {
        return this.tokenRepository.getRefreshTokensForClient(client);
    }

    public void clearExpiredTokens() {
        logger.info("Cleaning out all expired tokens");
        Collection<OAuth2AccessTokenEntity> accessTokens = this.getExpiredAccessTokens();
        logger.info("Found " + accessTokens.size() + " expired access tokens");
        for (OAuth2AccessTokenEntity oAuth2AccessTokenEntity : accessTokens) {
            this.revokeAccessToken(oAuth2AccessTokenEntity);
        }
        Collection<OAuth2RefreshTokenEntity> refreshTokens = this.getExpiredRefreshTokens();
        logger.info("Found " + refreshTokens.size() + " expired refresh tokens");
        for (OAuth2RefreshTokenEntity oAuth2RefreshTokenEntity : refreshTokens) {
            this.revokeRefreshToken(oAuth2RefreshTokenEntity);
        }
    }

    private Collection<OAuth2AccessTokenEntity> getExpiredAccessTokens() {
        return Collections2.filter((Collection)this.tokenRepository.getAllAccessTokens(), this.isAccessTokenExpired);
    }

    private Collection<OAuth2RefreshTokenEntity> getExpiredRefreshTokens() {
        return Collections2.filter((Collection)this.tokenRepository.getAllRefreshTokens(), this.isRefreshTokenExpired);
    }

    public OAuth2AccessTokenEntity saveAccessToken(OAuth2AccessTokenEntity accessToken) {
        return this.tokenRepository.saveAccessToken(accessToken);
    }

    public OAuth2RefreshTokenEntity saveRefreshToken(OAuth2RefreshTokenEntity refreshToken) {
        return this.tokenRepository.saveRefreshToken(refreshToken);
    }

    public TokenEnhancer getTokenEnhancer() {
        return this.tokenEnhancer;
    }

    public void setTokenEnhancer(TokenEnhancer tokenEnhancer) {
        this.tokenEnhancer = tokenEnhancer;
    }

    public OAuth2AccessTokenEntity getAccessTokenForIdToken(OAuth2AccessTokenEntity idToken) {
        return this.tokenRepository.getAccessTokenForIdToken(idToken);
    }
}

