/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.service.impl;

import com.google.common.collect.HashMultiset;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.mitre.oauth2.model.ClientDetailsEntity;
import org.mitre.oauth2.service.ClientDetailsEntityService;
import org.mitre.openid.connect.model.ApprovedSite;
import org.mitre.openid.connect.service.ApprovedSiteService;
import org.mitre.openid.connect.service.StatsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultStatsService
implements StatsService {
    @Autowired
    private ApprovedSiteService approvedSiteService;
    @Autowired
    private ClientDetailsEntityService clientService;

    public Map<String, Integer> calculateSummaryStats() {
        Collection allSites = this.approvedSiteService.getAll();
        HashSet<String> userIds = new HashSet<String>();
        HashSet<String> clientIds = new HashSet<String>();
        for (ApprovedSite approvedSite : allSites) {
            userIds.add(approvedSite.getUserId());
            clientIds.add(approvedSite.getClientId());
        }
        HashMap<String, Integer> e = new HashMap<String, Integer>();
        e.put("approvalCount", allSites.size());
        e.put("userCount", userIds.size());
        e.put("clientCount", clientIds.size());
        return e;
    }

    public Map<Long, Integer> calculateByClientId() {
        Collection allSites = this.approvedSiteService.getAll();
        HashMultiset clientIds = HashMultiset.create();
        for (ApprovedSite approvedSite : allSites) {
            clientIds.add((Object)approvedSite.getClientId());
        }
        Map<Long, Integer> counts = this.getEmptyClientCountMap();
        for (String clientId : clientIds) {
            ClientDetailsEntity client = this.clientService.loadClientByClientId(clientId);
            counts.put(client.getId(), clientIds.count((Object)clientId));
        }
        return counts;
    }

    public Integer countForClientId(Long id) {
        Map<Long, Integer> counts = this.calculateByClientId();
        return counts.get(id);
    }

    private Map<Long, Integer> getEmptyClientCountMap() {
        HashMap<Long, Integer> counts = new HashMap<Long, Integer>();
        Collection clients = this.clientService.getAllClients();
        for (ClientDetailsEntity client : clients) {
            counts.put(client.getId(), 0);
        }
        return counts;
    }
}

