/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.view;

import com.google.common.base.Joiner;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Type;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mitre.oauth2.model.OAuth2AccessTokenEntity;
import org.mitre.oauth2.model.OAuth2RefreshTokenEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.web.servlet.view.AbstractView;

@Component(value="tokenIntrospection")
public class TokenIntrospectionView
extends AbstractView {
    private static Logger logger = LoggerFactory.getLogger(TokenIntrospectionView.class);

    protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) {
        Gson gson = new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new ExclusionStrategy(){

            public boolean shouldSkipField(FieldAttributes f) {
                return false;
            }

            public boolean shouldSkipClass(Class<?> clazz) {
                return clazz.equals(BeanPropertyBindingResult.class);
            }
        }}).registerTypeAdapter(OAuth2AccessTokenEntity.class, (Object)new JsonSerializer<OAuth2AccessTokenEntity>(){

            public JsonElement serialize(OAuth2AccessTokenEntity src, Type typeOfSrc, JsonSerializationContext context) {
                JsonObject token = new JsonObject();
                token.addProperty("active", Boolean.valueOf(true));
                token.addProperty("scope", Joiner.on((String)" ").join((Iterable)src.getScope()));
                token.add("exp", context.serialize((Object)src.getExpiration()));
                token.addProperty("sub", src.getAuthenticationHolder().getAuthentication().getName());
                token.addProperty("client_id", src.getAuthenticationHolder().getAuthentication().getOAuth2Request().getClientId());
                token.addProperty("token_type", src.getTokenType());
                return token;
            }
        }).registerTypeAdapter(OAuth2RefreshTokenEntity.class, (Object)new JsonSerializer<OAuth2RefreshTokenEntity>(){

            public JsonElement serialize(OAuth2RefreshTokenEntity src, Type typeOfSrc, JsonSerializationContext context) {
                JsonObject token = new JsonObject();
                token.addProperty("active", Boolean.valueOf(true));
                token.addProperty("scope", Joiner.on((String)" ").join((Iterable)src.getAuthenticationHolder().getAuthentication().getOAuth2Request().getScope()));
                token.add("exp", context.serialize((Object)src.getExpiration()));
                token.addProperty("sub", src.getAuthenticationHolder().getAuthentication().getName());
                token.addProperty("client_id", src.getAuthenticationHolder().getAuthentication().getOAuth2Request().getClientId());
                return token;
            }
        }).setDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").create();
        response.setContentType("application/json");
        try {
            PrintWriter out = response.getWriter();
            Map<String, Object> obj = model.get("entity");
            if (obj == null) {
                obj = model;
            }
            gson.toJson(obj, (Appendable)out);
        }
        catch (IOException e) {
            logger.error("IOException occurred in TokenIntrospectionView.java: ", (Throwable)e);
        }
    }
}

