/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.repository.impl;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.mitre.oauth2.model.AuthorizationCodeEntity;
import org.mitre.oauth2.repository.AuthorizationCodeRepository;
import org.mitre.util.jpa.JpaUtil;
import org.springframework.security.oauth2.common.exceptions.InvalidGrantException;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class JpaAuthorizationCodeRepository
implements AuthorizationCodeRepository {
    @PersistenceContext
    EntityManager manager;

    @Transactional
    public AuthorizationCodeEntity save(AuthorizationCodeEntity authorizationCode) {
        return (AuthorizationCodeEntity)JpaUtil.saveOrUpdate((Object)authorizationCode.getId(), (EntityManager)this.manager, (Object)authorizationCode);
    }

    @Transactional
    public OAuth2Authentication consume(String code) throws InvalidGrantException {
        TypedQuery query = this.manager.createNamedQuery("AuthorizationCodeEntity.getByValue", AuthorizationCodeEntity.class);
        query.setParameter("code", (Object)code);
        AuthorizationCodeEntity result = (AuthorizationCodeEntity)JpaUtil.getSingleResult((List)query.getResultList());
        if (result == null) {
            throw new InvalidGrantException("JpaAuthorizationCodeRepository: no authorization code found for value " + code);
        }
        OAuth2Authentication authRequest = result.getAuthentication();
        this.manager.remove((Object)result);
        return authRequest;
    }
}

