/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.OctetSequenceKey;
import com.nimbusds.jose.jwk.Use;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.jwt.ReadOnlyJWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.mitre.jwt.encryption.service.JwtEncryptionAndDecryptionService;
import org.mitre.jwt.signer.service.JwtSigningAndValidationService;
import org.mitre.jwt.signer.service.impl.DefaultJwtSigningAndValidationService;
import org.mitre.jwt.signer.service.impl.JWKSetCacheService;
import org.mitre.oauth2.model.ClientDetailsEntity;
import org.mitre.oauth2.service.ClientDetailsEntityService;
import org.mitre.oauth2.service.SystemScopeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.oauth2.common.exceptions.InvalidClientException;
import org.springframework.security.oauth2.common.util.OAuth2Utils;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.DefaultOAuth2RequestFactory;
import org.springframework.stereotype.Component;

@Component(value="connectOAuth2RequestFactory")
public class ConnectOAuth2RequestFactory
extends DefaultOAuth2RequestFactory {
    private static Logger logger = LoggerFactory.getLogger(ConnectOAuth2RequestFactory.class);
    private ClientDetailsEntityService clientDetailsService;
    @Autowired
    private JWKSetCacheService validators;
    @Autowired
    private SystemScopeService systemScopes;
    @Autowired
    private JwtEncryptionAndDecryptionService encryptionService;
    private JsonParser parser = new JsonParser();

    @Autowired
    public ConnectOAuth2RequestFactory(ClientDetailsEntityService clientDetailsService) {
        super((ClientDetailsService)clientDetailsService);
        this.clientDetailsService = clientDetailsService;
    }

    public AuthorizationRequest createAuthorizationRequest(Map<String, String> inputParams) {
        JsonObject claimsRequest;
        AuthorizationRequest request = new AuthorizationRequest(inputParams, Collections.emptyMap(), inputParams.get("client_id"), OAuth2Utils.parseParameterList((String)inputParams.get("scope")), null, null, false, inputParams.get("state"), inputParams.get("redirect_uri"), OAuth2Utils.parseParameterList((String)inputParams.get("response_type")));
        if (inputParams.containsKey("prompt")) {
            request.getExtensions().put("prompt", inputParams.get("prompt"));
        }
        if (inputParams.containsKey("nonce")) {
            request.getExtensions().put("nonce", inputParams.get("nonce"));
        }
        if (inputParams.containsKey("claims") && (claimsRequest = this.parseClaimRequest(inputParams.get("claims"))) != null) {
            request.getExtensions().put("claims", claimsRequest.toString());
        }
        if (inputParams.containsKey("max_age")) {
            request.getExtensions().put("max_age", inputParams.get("max_age"));
        }
        if (inputParams.containsKey("request")) {
            request.getExtensions().put("request", inputParams.get("request"));
            this.processRequestObject(inputParams.get("request"), request);
        }
        if (request.getClientId() != null) {
            ClientDetailsEntity client = this.clientDetailsService.loadClientByClientId(request.getClientId());
            if (request.getScope() == null || request.getScope().isEmpty()) {
                Set clientScopes = client.getScope();
                request.setScope((Collection)clientScopes);
            }
            if (request.getExtensions().get("max_age") == null && client.getDefaultMaxAge() != null) {
                request.getExtensions().put("max_age", client.getDefaultMaxAge().toString());
            }
        }
        String csrf = UUID.randomUUID().toString();
        request.getExtensions().put("csrf", csrf);
        return request;
    }

    private void processRequestObject(String jwtString, AuthorizationRequest request) {
        try {
            JsonObject claimRequest;
            Set scope;
            String prompt;
            String display;
            String nonce;
            String state;
            String redirectUri;
            ReadOnlyJWTClaimsSet claims;
            Set responseTypes;
            ClientDetailsEntity client;
            JWT jwt = JWTParser.parse((String)jwtString);
            if (jwt instanceof SignedJWT) {
                JwtSigningAndValidationService validator;
                SignedJWT signedJwt = (SignedJWT)jwt;
                if (request.getClientId() == null) {
                    request.setClientId(signedJwt.getJWTClaimsSet().getStringClaim("client_id"));
                }
                if ((client = this.clientDetailsService.loadClientByClientId(request.getClientId())) == null) {
                    throw new InvalidClientException("Client not found: " + request.getClientId());
                }
                JWSAlgorithm alg = signedJwt.getHeader().getAlgorithm();
                if (client.getRequestObjectSigningAlg() == null || !client.getRequestObjectSigningAlg().equals((Object)alg)) {
                    throw new InvalidClientException("Client's registered request object signing algorithm (" + client.getRequestObjectSigningAlg() + ") does not match request object's actual algorithm (" + alg.getName() + ")");
                }
                if (alg.equals((Object)JWSAlgorithm.RS256) || alg.equals((Object)JWSAlgorithm.RS384) || alg.equals((Object)JWSAlgorithm.RS512)) {
                    if (client.getJwksUri() == null) {
                        throw new InvalidClientException("Client must have a JWKS URI registered to use signed request objects.");
                    }
                    validator = this.validators.getValidator(client.getJwksUri());
                    if (validator == null) {
                        throw new InvalidClientException("Unable to create signature validator for client's JWKS URI: " + client.getJwksUri());
                    }
                    if (!validator.validateSignature(signedJwt)) {
                        throw new InvalidClientException("Signature did not validate for presented JWT request object.");
                    }
                } else if (alg.equals((Object)JWSAlgorithm.HS256) || alg.equals((Object)JWSAlgorithm.HS384) || alg.equals((Object)JWSAlgorithm.HS512)) {
                    validator = this.getSymmetricValidtor(client);
                    if (validator == null) {
                        throw new InvalidClientException("Unable to create signature validator for client's secret: " + client.getClientSecret());
                    }
                    if (!validator.validateSignature(signedJwt)) {
                        throw new InvalidClientException("Signature did not validate for presented JWT request object.");
                    }
                }
            } else if (jwt instanceof PlainJWT) {
                PlainJWT plainJwt = (PlainJWT)jwt;
                if (request.getClientId() == null) {
                    request.setClientId(plainJwt.getJWTClaimsSet().getStringClaim("client_id"));
                }
                if ((client = this.clientDetailsService.loadClientByClientId(request.getClientId())) == null) {
                    throw new InvalidClientException("Client not found: " + request.getClientId());
                }
                if (client.getRequestObjectSigningAlg() == null) {
                    throw new InvalidClientException("Client is not registered for unsigned request objects (no request_object_signing_alg registered)");
                }
                if (!client.getRequestObjectSigningAlg().equals((Object)Algorithm.NONE)) {
                    throw new InvalidClientException("Client is not registered for unsigned request objects (request_object_signing_alg is " + client.getRequestObjectSigningAlg() + ")");
                }
            } else if (jwt instanceof EncryptedJWT) {
                EncryptedJWT encryptedJWT = (EncryptedJWT)jwt;
                this.encryptionService.decryptJwt((JWEObject)encryptedJWT);
                if (!encryptedJWT.getState().equals((Object)JWEObject.State.DECRYPTED)) {
                    throw new InvalidClientException("Unable to decrypt the request object");
                }
                if (request.getClientId() == null) {
                    request.setClientId(encryptedJWT.getJWTClaimsSet().getStringClaim("client_id"));
                }
                if ((client = this.clientDetailsService.loadClientByClientId(request.getClientId())) == null) {
                    throw new InvalidClientException("Client not found: " + request.getClientId());
                }
            }
            if ((responseTypes = OAuth2Utils.parseParameterList((String)(claims = jwt.getJWTClaimsSet()).getStringClaim("response_type"))) != null && !responseTypes.isEmpty()) {
                if (!responseTypes.equals(request.getResponseTypes())) {
                    logger.info("Mismatch between request object and regular parameter for response_type, using request object");
                }
                request.setResponseTypes(responseTypes);
            }
            if ((redirectUri = claims.getStringClaim("redirect_uri")) != null) {
                if (!redirectUri.equals(request.getRedirectUri())) {
                    logger.info("Mismatch between request object and regular parameter for redirect_uri, using request object");
                }
                request.setRedirectUri(redirectUri);
            }
            if ((state = claims.getStringClaim("state")) != null) {
                if (!state.equals(request.getState())) {
                    logger.info("Mismatch between request object and regular parameter for state, using request object");
                }
                request.setState(state);
            }
            if ((nonce = claims.getStringClaim("nonce")) != null) {
                if (!nonce.equals(request.getExtensions().get("nonce"))) {
                    logger.info("Mismatch between request object and regular parameter for nonce, using request object");
                }
                request.getExtensions().put("nonce", nonce);
            }
            if ((display = claims.getStringClaim("display")) != null) {
                if (!display.equals(request.getExtensions().get("display"))) {
                    logger.info("Mismatch between request object and regular parameter for display, using request object");
                }
                request.getExtensions().put("display", display);
            }
            if ((prompt = claims.getStringClaim("prompt")) != null) {
                if (!prompt.equals(request.getExtensions().get("prompt"))) {
                    logger.info("Mismatch between request object and regular parameter for prompt, using request object");
                }
                request.getExtensions().put("prompt", prompt);
            }
            if ((scope = OAuth2Utils.parseParameterList((String)claims.getStringClaim("scope"))) != null && !scope.isEmpty()) {
                if (!scope.equals(request.getScope())) {
                    logger.info("Mismatch between request object and regular parameter for scope, using request object");
                }
                request.setScope((Collection)scope);
            }
            if ((claimRequest = this.parseClaimRequest(claims.getStringClaim("claims"))) != null) {
                if (!claimRequest.equals((Object)this.parseClaimRequest(((Serializable)request.getExtensions().get("claims")).toString()))) {
                    logger.info("Mismatch between request object and regular parameter for claims, using request object");
                }
                request.getExtensions().put("claims", claimRequest.toString());
            }
        }
        catch (ParseException e) {
            logger.error("ParseException while parsing RequestObject:", (Throwable)e);
        }
    }

    private JsonObject parseClaimRequest(String claimRequestString) {
        JsonElement el = this.parser.parse(claimRequestString);
        if (el != null && el.isJsonObject()) {
            return el.getAsJsonObject();
        }
        return null;
    }

    private JwtSigningAndValidationService getSymmetricValidtor(ClientDetailsEntity client) {
        if (client == null) {
            logger.error("Couldn't create symmetric validator for null client");
            return null;
        }
        if (Strings.isNullOrEmpty((String)client.getClientSecret())) {
            logger.error("Couldn't create symmetric validator for client " + client.getClientId() + " without a client secret");
            return null;
        }
        try {
            OctetSequenceKey jwk = new OctetSequenceKey(Base64URL.encode((String)client.getClientSecret()), Use.SIGNATURE, null, client.getClientId(), null, null, null);
            ImmutableMap keys = ImmutableMap.of((Object)client.getClientId(), (Object)jwk);
            DefaultJwtSigningAndValidationService service = new DefaultJwtSigningAndValidationService((Map)keys);
            return service;
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("Couldn't create symmetric validator for client " + client.getClientId(), (Throwable)e);
        }
        catch (InvalidKeySpecException e) {
            logger.error("Couldn't create symmetric validator for client " + client.getClientId(), (Throwable)e);
        }
        return null;
    }
}

