/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.token;

import com.google.common.collect.Lists;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.ReadOnlyJWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.mitre.jwt.signer.service.JwtSigningAndValidationService;
import org.mitre.oauth2.model.ClientDetailsEntity;
import org.mitre.oauth2.model.OAuth2AccessTokenEntity;
import org.mitre.oauth2.service.ClientDetailsEntityService;
import org.mitre.openid.connect.config.ConfigurationPropertiesBean;
import org.mitre.openid.connect.model.UserInfo;
import org.mitre.openid.connect.service.ApprovedSiteService;
import org.mitre.openid.connect.service.OIDCTokenService;
import org.mitre.openid.connect.service.UserInfoService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.token.TokenEnhancer;
import org.springframework.stereotype.Service;

@Service
public class ConnectTokenEnhancer
implements TokenEnhancer {
    Logger logger = LoggerFactory.getLogger(ConnectTokenEnhancer.class);
    @Autowired
    private ConfigurationPropertiesBean configBean;
    @Autowired
    private JwtSigningAndValidationService jwtService;
    @Autowired
    private ClientDetailsEntityService clientService;
    @Autowired
    private ApprovedSiteService approvedSiteService;
    @Autowired
    private UserInfoService userInfoService;
    @Autowired
    private OIDCTokenService connectTokenService;

    public OAuth2AccessToken enhance(OAuth2AccessToken accessToken, OAuth2Authentication authentication) {
        OAuth2AccessTokenEntity token = (OAuth2AccessTokenEntity)accessToken;
        OAuth2Request originalAuthRequest = authentication.getOAuth2Request();
        String clientId = originalAuthRequest.getClientId();
        ClientDetailsEntity client = this.clientService.loadClientByClientId(clientId);
        JWTClaimsSet claims = new JWTClaimsSet();
        claims.setAudience((List)Lists.newArrayList((Object[])new String[]{clientId}));
        claims.setIssuer(this.configBean.getIssuer());
        claims.setIssueTime(new Date());
        claims.setExpirationTime(token.getExpiration());
        claims.setJWTID(UUID.randomUUID().toString());
        JWSAlgorithm signingAlg = this.jwtService.getDefaultSigningAlgorithm();
        if (client.getIdTokenSignedResponseAlg() != null) {
            signingAlg = client.getIdTokenSignedResponseAlg();
        }
        SignedJWT signed = new SignedJWT(new JWSHeader(signingAlg), (ReadOnlyJWTClaimsSet)claims);
        this.jwtService.signJwt(signed);
        token.setJwt((JWT)signed);
        if (originalAuthRequest.getScope().contains("openid")) {
            String username = authentication.getName();
            UserInfo userInfo = this.userInfoService.getByUsernameAndClientId(username, clientId);
            OAuth2AccessTokenEntity idTokenEntity = this.connectTokenService.createIdToken(client, originalAuthRequest, claims.getIssueTime(), userInfo.getSub(), signingAlg, token);
            token.setIdToken(idTokenEntity);
        }
        return token;
    }

    public ConfigurationPropertiesBean getConfigBean() {
        return this.configBean;
    }

    public void setConfigBean(ConfigurationPropertiesBean configBean) {
        this.configBean = configBean;
    }

    public JwtSigningAndValidationService getJwtService() {
        return this.jwtService;
    }

    public void setJwtService(JwtSigningAndValidationService jwtService) {
        this.jwtService = jwtService;
    }

    public ClientDetailsEntityService getClientService() {
        return this.clientService;
    }

    public void setClientService(ClientDetailsEntityService clientService) {
        this.clientService = clientService;
    }
}

