/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.discovery.web;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JWSAlgorithm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.mitre.discovery.util.WebfingerURLNormalizer;
import org.mitre.jwt.encryption.service.JwtEncryptionAndDecryptionService;
import org.mitre.jwt.signer.service.JwtSigningAndValidationService;
import org.mitre.oauth2.service.SystemScopeService;
import org.mitre.openid.connect.config.ConfigurationPropertiesBean;
import org.mitre.openid.connect.model.UserInfo;
import org.mitre.openid.connect.service.UserInfoService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@Controller
public class DiscoveryEndpoint {
    private static Logger logger = LoggerFactory.getLogger(DiscoveryEndpoint.class);
    @Autowired
    private ConfigurationPropertiesBean config;
    @Autowired
    private SystemScopeService scopeService;
    @Autowired
    private JwtSigningAndValidationService signService;
    @Autowired
    private JwtEncryptionAndDecryptionService encService;
    @Autowired
    private UserInfoService userService;
    private Function<Algorithm, String> toAlgorithmName = new Function<Algorithm, String>(){

        public String apply(Algorithm alg) {
            if (alg == null) {
                return null;
            }
            return alg.getName();
        }
    };

    @RequestMapping(value={"/.well-known/webfinger"}, params={"resource", "rel=http://openid.net/specs/connect/1.0/issuer"}, produces={"application/json"})
    public String webfinger(@RequestParam(value="resource") String resource, Model model) {
        if (!resource.equals(this.config.getIssuer())) {
            UriComponents resourceUri = WebfingerURLNormalizer.normalizeResource((String)resource);
            if (resourceUri != null && resourceUri.getScheme() != null && resourceUri.getScheme().equals("acct")) {
                UserInfo user = this.userService.getByUsername(resourceUri.getUserInfo());
                if (user == null) {
                    logger.info("User not found: " + resource);
                    model.addAttribute("code", (Object)HttpStatus.NOT_FOUND);
                    return "httpCodeView";
                }
                UriComponents issuerComponents = UriComponentsBuilder.fromHttpUrl((String)this.config.getIssuer()).build();
                if (!Strings.nullToEmpty((String)issuerComponents.getHost()).equals(Strings.nullToEmpty((String)resourceUri.getHost()))) {
                    logger.info("Host mismatch, expected " + issuerComponents.getHost() + " got " + resourceUri.getHost());
                    model.addAttribute("code", (Object)HttpStatus.NOT_FOUND);
                    return "httpCodeView";
                }
            } else {
                logger.info("Unknown URI format: " + resource);
                model.addAttribute("code", (Object)HttpStatus.NOT_FOUND);
                return "httpCodeView";
            }
        }
        model.addAttribute("resource", (Object)resource);
        model.addAttribute("issuer", (Object)this.config.getIssuer());
        return "webfingerView";
    }

    @RequestMapping(value={"/.well-known/openid-configuration"})
    public String providerConfiguration(Model model) {
        String baseUrl = this.config.getIssuer();
        if (!baseUrl.endsWith("/")) {
            logger.warn("Configured issuer doesn't end in /, adding for discovery: " + baseUrl);
            baseUrl = baseUrl.concat("/");
        }
        Collection serverSigningAlgs = this.signService.getAllSigningAlgsSupported();
        ArrayList clientSymmetricSigningAlgs = Lists.newArrayList((Object[])new JWSAlgorithm[]{JWSAlgorithm.HS256, JWSAlgorithm.HS384, JWSAlgorithm.HS512});
        ArrayList clientSymmetricAndAsymmetricSigningAlgs = Lists.newArrayList((Object[])new JWSAlgorithm[]{JWSAlgorithm.HS256, JWSAlgorithm.HS384, JWSAlgorithm.HS512, JWSAlgorithm.RS256, JWSAlgorithm.RS384, JWSAlgorithm.RS512});
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("issuer", this.config.getIssuer());
        m.put("authorization_endpoint", baseUrl + "authorize");
        m.put("token_endpoint", baseUrl + "token");
        m.put("userinfo_endpoint", baseUrl + "userinfo");
        m.put("jwks_uri", baseUrl + "jwk");
        m.put("registration_endpoint", baseUrl + "register");
        m.put("scopes_supported", this.scopeService.toStrings(this.scopeService.getDynReg()));
        m.put("response_types_supported", Lists.newArrayList((Object[])new String[]{"code", "token"}));
        m.put("grant_types_supported", Lists.newArrayList((Object[])new String[]{"authorization_code", "implicit", "urn:ietf:params:oauth:grant-type:jwt-bearer", "client_credentials", "urn:ietf:params:oauth:grant_type:redelegate"}));
        m.put("subject_types_supported", Lists.newArrayList((Object[])new String[]{"public", "pairwise"}));
        m.put("userinfo_signing_alg_values_supported", Collections2.transform((Collection)clientSymmetricAndAsymmetricSigningAlgs, this.toAlgorithmName));
        m.put("userinfo_encryption_alg_values_supported", Collections2.transform((Collection)this.encService.getAllEncryptionAlgsSupported(), this.toAlgorithmName));
        m.put("userinfo_encryption_enc_values_supported", Collections2.transform((Collection)this.encService.getAllEncryptionEncsSupported(), this.toAlgorithmName));
        m.put("id_token_signing_alg_values_supported", Collections2.transform((Collection)clientSymmetricAndAsymmetricSigningAlgs, this.toAlgorithmName));
        m.put("id_token_encryption_alg_values_supported", Collections2.transform((Collection)this.encService.getAllEncryptionAlgsSupported(), this.toAlgorithmName));
        m.put("id_token_encryption_enc_values_supported", Collections2.transform((Collection)this.encService.getAllEncryptionEncsSupported(), this.toAlgorithmName));
        m.put("request_object_signing_alg_values_supported", Collections2.transform((Collection)clientSymmetricAndAsymmetricSigningAlgs, this.toAlgorithmName));
        m.put("request_object_encryption_alg_values_supported", Collections2.transform((Collection)this.encService.getAllEncryptionAlgsSupported(), this.toAlgorithmName));
        m.put("request_object_encryption_enc_values_supported", Collections2.transform((Collection)this.encService.getAllEncryptionEncsSupported(), this.toAlgorithmName));
        m.put("token_endpoint_auth_methods_supported", Lists.newArrayList((Object[])new String[]{"client_secret_post", "client_secret_basic", "client_secret_jwt", "private_key_jwt", "none"}));
        m.put("token_endpoint_auth_signing_alg_values_supported", Collections2.transform((Collection)clientSymmetricAndAsymmetricSigningAlgs, this.toAlgorithmName));
        m.put("claim_types_supported", Lists.newArrayList((Object[])new String[]{"normal"}));
        m.put("claims_supported", Lists.newArrayList((Object[])new String[]{"sub", "name", "preferred_username", "given_name", "family_name", "middle_name", "nickname", "profile", "picture", "website", "gender", "zone_info", "locale", "updated_time", "birthdate", "email", "email_verified", "phone_number", "address"}));
        m.put("service_documentation", baseUrl + "about");
        m.put("claims_parameter_supported", false);
        m.put("request_parameter_supported", true);
        m.put("request_uri_parameter_supported", false);
        m.put("require_request_uri_registration", false);
        m.put("op_policy_uri", baseUrl + "about");
        m.put("op_tos_uri", baseUrl + "about");
        m.put("introspection_endpoint", baseUrl + "introspect");
        m.put("revocation_endpoint", baseUrl + "revoke");
        model.addAttribute("entity", m);
        return "jsonEntityView";
    }
}

