/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.assertion;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.ReadOnlyJWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.text.ParseException;
import java.util.Date;
import org.mitre.jwt.signer.service.JwtSigningAndValidationService;
import org.mitre.jwt.signer.service.impl.JWKSetCacheService;
import org.mitre.jwt.signer.service.impl.SymmetricCacheService;
import org.mitre.oauth2.model.ClientDetailsEntity;
import org.mitre.oauth2.service.ClientDetailsEntityService;
import org.mitre.openid.connect.assertion.JwtBearerAssertionAuthenticationToken;
import org.mitre.openid.connect.config.ConfigurationPropertiesBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.oauth2.common.exceptions.InvalidClientException;

public class JwtBearerAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger logger = LoggerFactory.getLogger(JwtBearerAuthenticationProvider.class);
    @Autowired
    private JWKSetCacheService validators;
    @Autowired
    private SymmetricCacheService symmetricCacheService;
    private int timeSkewAllowance = 300;
    @Autowired
    private ClientDetailsEntityService clientService;
    @Autowired
    private ConfigurationPropertiesBean config;

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        JwtBearerAssertionAuthenticationToken jwtAuth = (JwtBearerAssertionAuthenticationToken)authentication;
        try {
            ClientDetailsEntity client = this.clientService.loadClientByClientId(jwtAuth.getClientId());
            JWT jwt = jwtAuth.getJwt();
            ReadOnlyJWTClaimsSet jwtClaims = jwt.getJWTClaimsSet();
            if (jwt instanceof SignedJWT) {
                SignedJWT jws = (SignedJWT)jwt;
                JWSAlgorithm alg = jws.getHeader().getAlgorithm();
                if (client.getTokenEndpointAuthSigningAlg() != null && !client.getTokenEndpointAuthSigningAlg().equals((Object)alg)) {
                    throw new InvalidClientException("Client's registered request object signing algorithm (" + client.getRequestObjectSigningAlg() + ") does not match request object's actual algorithm (" + alg.getName() + ")");
                }
                if (client.getTokenEndpointAuthMethod().equals((Object)ClientDetailsEntity.AuthMethod.PRIVATE_KEY) && (alg.equals((Object)JWSAlgorithm.RS256) || alg.equals((Object)JWSAlgorithm.RS384) || alg.equals((Object)JWSAlgorithm.RS512))) {
                    JwtSigningAndValidationService validator = this.validators.getValidator(client.getJwksUri());
                    if (validator == null) {
                        throw new AuthenticationServiceException("Unable to create signature validator for client's JWKS URI: " + client.getJwksUri());
                    }
                    if (!validator.validateSignature(jws)) {
                        throw new AuthenticationServiceException("Signature did not validate for presented JWT authentication.");
                    }
                } else if (client.getTokenEndpointAuthMethod().equals((Object)ClientDetailsEntity.AuthMethod.SECRET_JWT) && (alg.equals((Object)JWSAlgorithm.HS256) || alg.equals((Object)JWSAlgorithm.HS384) || alg.equals((Object)JWSAlgorithm.HS512))) {
                    JwtSigningAndValidationService validator = this.symmetricCacheService.getSymmetricValidtor(client);
                    if (validator == null) {
                        throw new AuthenticationServiceException("Unable to create signature validator for client's secret: " + client.getClientSecret());
                    }
                    if (!validator.validateSignature(jws)) {
                        throw new AuthenticationServiceException("Signature did not validate for presented JWT authentication.");
                    }
                }
            }
            if (jwtClaims.getIssuer() == null) {
                throw new AuthenticationServiceException("Assertion Token Issuer is null");
            }
            if (!jwtClaims.getIssuer().equals(client.getClientId())) {
                throw new AuthenticationServiceException("Issuers do not match, expected " + client.getClientId() + " got " + jwtClaims.getIssuer());
            }
            if (jwtClaims.getExpirationTime() == null) {
                throw new AuthenticationServiceException("Assertion Token does not have required expiration claim");
            }
            Date now = new Date(System.currentTimeMillis() - (long)(this.timeSkewAllowance * 1000));
            if (now.after(jwtClaims.getExpirationTime())) {
                throw new AuthenticationServiceException("Assertion Token is expired: " + jwtClaims.getExpirationTime());
            }
            if (jwtClaims.getNotBeforeTime() != null && (now = new Date(System.currentTimeMillis() + (long)(this.timeSkewAllowance * 1000))).before(jwtClaims.getNotBeforeTime())) {
                throw new AuthenticationServiceException("Assertion Token not valid untill: " + jwtClaims.getNotBeforeTime());
            }
            if (jwtClaims.getIssueTime() != null && (now = new Date(System.currentTimeMillis() + (long)(this.timeSkewAllowance * 1000))).before(jwtClaims.getIssueTime())) {
                throw new AuthenticationServiceException("Assertion Token was issued in the future: " + jwtClaims.getIssueTime());
            }
            if (jwtClaims.getAudience() == null) {
                throw new AuthenticationServiceException("Assertion token audience is null");
            }
            if (!jwtClaims.getAudience().contains(this.config.getIssuer()) && !jwtClaims.getAudience().contains(this.config.getIssuer() + "token")) {
                throw new AuthenticationServiceException("Audience does not match, expected " + this.config.getIssuer() + " or " + this.config.getIssuer() + "token" + " got " + jwtClaims.getAudience());
            }
            return new JwtBearerAssertionAuthenticationToken(client.getClientId(), jwt, client.getAuthorities());
        }
        catch (InvalidClientException e) {
            throw new UsernameNotFoundException("Could not find client: " + jwtAuth.getClientId());
        }
        catch (ParseException e) {
            logger.error("Failure during authentication, error was: ", (Throwable)e);
            throw new AuthenticationServiceException("Invalid JWT format");
        }
    }

    public boolean supports(Class<?> authentication) {
        return JwtBearerAssertionAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

