/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.view;

import com.google.common.base.Strings;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mitre.openid.connect.view.JsonEntityView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.web.servlet.view.AbstractView;

@Component(value="jsonErrorView")
public class JsonErrorView
extends AbstractView {
    private static Logger logger = LoggerFactory.getLogger(JsonEntityView.class);
    private Gson gson = new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new ExclusionStrategy(){

        public boolean shouldSkipField(FieldAttributes f) {
            return false;
        }

        public boolean shouldSkipClass(Class<?> clazz) {
            return clazz.equals(BeanPropertyBindingResult.class);
        }
    }}).serializeNulls().setDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").create();

    protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) {
        response.setContentType("application/json");
        HttpStatus code = (HttpStatus)model.get("code");
        if (code == null) {
            code = HttpStatus.OK;
        }
        response.setStatus(code.value());
        try {
            PrintWriter out = response.getWriter();
            String errorTitle = (String)model.get("error");
            if (Strings.isNullOrEmpty((String)errorTitle)) {
                errorTitle = "Error";
            }
            String errorMessage = (String)model.get("errorMessage");
            JsonObject obj = new JsonObject();
            obj.addProperty("error", errorTitle);
            obj.addProperty("error_description", errorMessage);
            this.gson.toJson((JsonElement)obj, (Appendable)out);
        }
        catch (IOException e) {
            logger.error("IOException in JsonErrorView.java: ", (Throwable)e);
        }
    }
}

