/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.view;

import com.google.common.base.Joiner;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.swing.text.DateFormatter;
import org.mitre.oauth2.model.OAuth2AccessTokenEntity;
import org.mitre.oauth2.model.OAuth2RefreshTokenEntity;
import org.mitre.openid.connect.model.UserInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.view.AbstractView;

@Component(value="tokenIntrospection")
public class TokenIntrospectionView
extends AbstractView {
    private static Logger logger = LoggerFactory.getLogger(TokenIntrospectionView.class);
    private static DateFormatter isoDateFormatter = new DateFormatter(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ"));
    private Gson gson = new GsonBuilder().create();

    protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) {
        block4: {
            response.setContentType("application/json");
            try {
                PrintWriter out = response.getWriter();
                UserInfo user = (UserInfo)model.get("user");
                Object obj = model.get("token");
                if (obj instanceof OAuth2AccessTokenEntity) {
                    this.gson.toJson((JsonElement)this.renderAccessToken((OAuth2AccessTokenEntity)obj, user), (Appendable)out);
                    break block4;
                }
                if (obj instanceof OAuth2RefreshTokenEntity) {
                    this.gson.toJson((JsonElement)this.renderRefreshToken((OAuth2RefreshTokenEntity)obj, user), (Appendable)out);
                    break block4;
                }
                throw new IOException("Couldn't find a valid entity to render");
            }
            catch (IOException e) {
                logger.error("IOException occurred in TokenIntrospectionView.java: ", (Throwable)e);
            }
        }
    }

    private JsonObject renderAccessToken(OAuth2AccessTokenEntity src, UserInfo user) {
        JsonObject token = new JsonObject();
        token.addProperty("active", Boolean.valueOf(true));
        token.addProperty("scope", Joiner.on((String)" ").join((Iterable)src.getScope()));
        if (src.getExpiration() != null) {
            try {
                token.addProperty("exp", isoDateFormatter.valueToString(src.getExpiration()));
            }
            catch (ParseException e) {
                logger.error("Problem formatting expiration date: " + src.getExpiration(), (Throwable)e);
            }
        }
        if (user != null) {
            token.addProperty("sub", user.getSub());
            token.addProperty("user_id", src.getAuthenticationHolder().getAuthentication().getName());
        } else {
            token.addProperty("sub", src.getAuthenticationHolder().getAuthentication().getName());
            token.addProperty("user_id", src.getAuthenticationHolder().getAuthentication().getName());
        }
        token.addProperty("client_id", src.getAuthenticationHolder().getAuthentication().getOAuth2Request().getClientId());
        token.addProperty("token_type", src.getTokenType());
        return token;
    }

    private JsonObject renderRefreshToken(OAuth2RefreshTokenEntity src, UserInfo user) {
        JsonObject token = new JsonObject();
        token.addProperty("active", Boolean.valueOf(true));
        token.addProperty("scope", Joiner.on((String)" ").join((Iterable)src.getAuthenticationHolder().getAuthentication().getOAuth2Request().getScope()));
        if (src.getExpiration() != null) {
            try {
                token.addProperty("exp", isoDateFormatter.valueToString(src.getExpiration()));
            }
            catch (ParseException e) {
                logger.error("Problem formatting expiration date: " + src.getExpiration(), (Throwable)e);
            }
        }
        if (user != null) {
            token.addProperty("sub", user.getSub());
            token.addProperty("user_id", src.getAuthenticationHolder().getAuthentication().getName());
        } else {
            token.addProperty("sub", src.getAuthenticationHolder().getAuthentication().getName());
            token.addProperty("user_id", src.getAuthenticationHolder().getAuthentication().getName());
        }
        token.addProperty("client_id", src.getAuthenticationHolder().getAuthentication().getOAuth2Request().getClientId());
        return token;
    }
}

