/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.repository.impl;

import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.mitre.openid.connect.model.WhitelistedSite;
import org.mitre.openid.connect.repository.WhitelistedSiteRepository;
import org.mitre.util.jpa.JpaUtil;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class JpaWhitelistedSiteRepository
implements WhitelistedSiteRepository {
    @PersistenceContext
    private EntityManager manager;

    @Transactional
    public Collection<WhitelistedSite> getAll() {
        TypedQuery query = this.manager.createNamedQuery("WhitelistedSite.getAll", WhitelistedSite.class);
        return query.getResultList();
    }

    @Transactional
    public WhitelistedSite getById(Long id) {
        return (WhitelistedSite)this.manager.find(WhitelistedSite.class, (Object)id);
    }

    @Transactional
    public void remove(WhitelistedSite whitelistedSite) {
        WhitelistedSite found = (WhitelistedSite)this.manager.find(WhitelistedSite.class, (Object)whitelistedSite.getId());
        if (found == null) {
            throw new IllegalArgumentException();
        }
        this.manager.remove((Object)found);
    }

    @Transactional
    public WhitelistedSite save(WhitelistedSite whiteListedSite) {
        return (WhitelistedSite)JpaUtil.saveOrUpdate((Object)whiteListedSite.getId(), (EntityManager)this.manager, (Object)whiteListedSite);
    }

    @Transactional
    public WhitelistedSite update(WhitelistedSite oldWhitelistedSite, WhitelistedSite whitelistedSite) {
        whitelistedSite.setId(oldWhitelistedSite.getId());
        return (WhitelistedSite)JpaUtil.saveOrUpdate((Object)oldWhitelistedSite.getId(), (EntityManager)this.manager, (Object)whitelistedSite);
    }

    @Transactional
    public WhitelistedSite getByClientId(String clientId) {
        TypedQuery query = this.manager.createNamedQuery("WhitelistedSite.getByClientId", WhitelistedSite.class);
        query.setParameter("clientId", (Object)clientId);
        return (WhitelistedSite)JpaUtil.getSingleResult((List)query.getResultList());
    }

    @Transactional
    public Collection<WhitelistedSite> getByCreator(String creatorId) {
        TypedQuery query = this.manager.createNamedQuery("WhitelistedSite.getByCreaterUserId", WhitelistedSite.class);
        query.setParameter("userId", (Object)creatorId);
        return query.getResultList();
    }
}

