/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.service.impl;

import java.util.Collection;
import org.mitre.openid.connect.model.WhitelistedSite;
import org.mitre.openid.connect.repository.WhitelistedSiteRepository;
import org.mitre.openid.connect.service.WhitelistedSiteService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class DefaultWhitelistedSiteService
implements WhitelistedSiteService {
    @Autowired
    private WhitelistedSiteRepository repository;

    public WhitelistedSite getById(Long id) {
        return this.repository.getById(id);
    }

    public void remove(WhitelistedSite whitelistedSite) {
        this.repository.remove(whitelistedSite);
    }

    public WhitelistedSite saveNew(WhitelistedSite whitelistedSite) {
        if (whitelistedSite.getId() != null) {
            throw new IllegalArgumentException("A new whitelisted site cannot be created with an id value already set: " + whitelistedSite.getId());
        }
        return this.repository.save(whitelistedSite);
    }

    public Collection<WhitelistedSite> getAll() {
        return this.repository.getAll();
    }

    public WhitelistedSite getByClientId(String clientId) {
        return this.repository.getByClientId(clientId);
    }

    public Collection<WhitelistedSite> getByCreator(String creatorId) {
        return this.repository.getByCreator(creatorId);
    }

    public WhitelistedSite update(WhitelistedSite oldWhitelistedSite, WhitelistedSite whitelistedSite) {
        if (oldWhitelistedSite == null || whitelistedSite == null) {
            throw new IllegalArgumentException("Neither the old or new sites may be null");
        }
        return this.repository.update(oldWhitelistedSite, whitelistedSite);
    }
}

